package com.bxm.localnews.msg.param;

import com.bxm.newidea.component.vo.BasicParam;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import lombok.experimental.Tolerate;

import java.util.List;

/**
 * 群推消息传输参数
 *
 * @author liujia
 * @date 2020-07-03 19:58
 **/
@EqualsAndHashCode(callSuper = true)
@Data
@Builder
@ToString
public class PushMessageBucket extends BasicParam {
    @Tolerate
    public PushMessageBucket() {
    }

    /**
     * 群推的消息ID
     */
    private Long pushMsgId;

    /**
     * 消息接收的目标ID
     */
    private List<Long> targetUserIds;

    /**
     * 当前分片索引下标
     */
    private Integer index;

    /**
     * 总分片数，当前分片与总分片一致则设置推送为结束
     */
    private Integer total;
}
