package com.bxm.localnews.msg.vo;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author 用户推送相关的token，包括推送的app token，微信token，手机号码
 */
@Data
public class MsgUserTokenBean implements Serializable {
    /**
     * 主键
     */
    private Long id;

    /**
     * 用户ID
     */
    private Long userId;

    /**
     * token类型，APP平台token，微信code，手机号码
     *
     * @see com.bxm.localnews.mq.common.constant.PlatformTypeEnum
     */
    private Byte type;

    /**
     * 设备类型（安卓、iOS、小程序）
     *
     * @see com.bxm.localnews.common.constant.PlatformEnum
     */
    private Byte platform;

    /**
     * token值
     */
    private String token;

    /**
     * 创建日期
     */
    private Date createTime;

    private static final long serialVersionUID = 1L;
}