package com.bxm.localnews.msg.rule.impl;

import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.msg.config.AppPushProperties;
import com.bxm.localnews.msg.rule.IPushRule;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.time.LocalTime;

/**
 * 时间段规则，防止在休息时间打扰用户，特殊指定强制推送的除外
 *
 * @author liujia
 * @date 2020-07-05 15:15
 **/
@Component
public class PeriodPushRule implements IPushRule {

    @Resource
    private AppPushProperties properties;

    @Override
    public boolean accpect(PushMessage message) {
        // 强制推送的消息不做处理,允许发送
        if (message.isForce()) {
            return true;
        }

        LocalTime now = LocalTime.now();
        return now.isAfter(properties.getStartLimitTime()) && now.isBefore(properties.getEndLimitTime());
    }

    @Override
    public boolean write() {
        // 时间段内不推送，但是仍然写入到个人消息中
        return true;
    }
}
