package com.bxm.localnews.msg.service;

import com.bxm.localnews.msg.dto.AdminPushMessageDTO;
import com.bxm.localnews.msg.dto.PushMessageStatistical;
import com.bxm.localnews.msg.param.PushMessageParam;
import com.bxm.localnews.msg.vo.AdminPushMessage;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;

import java.util.Collection;

/**
 * 运营管理后台的消息管理
 * V3.4.0 从运营后台迁移至消息服务，进行了一定的重构和适配
 *
 * @author liujia
 */
public interface AdminPushMessageService {

    /**
     * 查询推送消息列表
     *
     * @param param 查询参数
     * @return 分页结果
     */
    PageWarper<AdminPushMessageDTO> queryPushMessageList(PushMessageParam param);

    /**
     * 根据id获取消息详情
     *
     * @param id
     * @return
     */
    AdminPushMessage getDetail(Long id);

    /**
     * 更新或者保存推送消息
     *
     * @param adminPushMessage
     * @return
     */
    Message saveOrUpdatePushMessage(AdminPushMessage adminPushMessage);

    /**
     * 更新推送消息的状态
     *
     * @param id
     * @param status
     * @return
     */
    Message updateStatusPushMessage(Long id, Byte status);

    /**
     * 测试推送消息
     *
     * @param id
     * @param userId
     * @return
     */
    Message testPushMessage(Long id, Long userId);

    /**
     * 立即推送消息
     *
     * @param id
     * @return
     */
    Message immediatelyPushMessage(Long id);


    /**
     * 获取对应消息的统计信息
     *
     * @param id 消息id
     * @return
     */
    Collection<PushMessageStatistical> getStatistical(Long id);


    /**
     * 测试批量推送消息
     *
     * @param id
     * @param userIds
     * @return
     */
    Message testPushMessage(Long id, String userIds);
}
