/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.msg.platform.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.common.constant.PlatformEnum;
import com.bxm.localnews.mq.common.constant.PlatformTypeEnum;
import com.bxm.localnews.mq.common.constant.PushFoldTypeEnum;
import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.mq.common.constant.PushSoundEnum;
import com.bxm.localnews.mq.common.constant.TemplateTypeEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.msg.config.AppPushProperties;
import com.bxm.localnews.msg.platform.impl.AbstractPushPlatform;
import com.bxm.localnews.msg.push.PushResponseCallback;
import com.bxm.localnews.msg.push.Response;
import com.bxm.localnews.msg.vo.MsgUserTokenBean;
import com.bxm.newidea.component.tools.StringUtils;
import com.gexin.rp.sdk.base.IPushResult;
import com.gexin.rp.sdk.base.ITemplate;
import com.gexin.rp.sdk.base.impl.SingleMessage;
import com.gexin.rp.sdk.base.impl.Target;
import com.gexin.rp.sdk.base.payload.APNPayload;
import com.gexin.rp.sdk.base.payload.Payload;
import com.gexin.rp.sdk.http.IGtPush;
import com.gexin.rp.sdk.template.NotificationTemplate;
import com.gexin.rp.sdk.template.TransmissionTemplate;
import com.gexin.rp.sdk.template.style.AbstractNotifyStyle;
import com.gexin.rp.sdk.template.style.Style6;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Component;

@Component
@RefreshScope
public class GetuiPushPlatform
extends AbstractPushPlatform {
    @Resource
    private AppPushProperties appPushProperties;
    private IGtPush iGtPush;

    @Override
    public PlatformTypeEnum getType() {
        return PlatformTypeEnum.GETUI;
    }

    @Override
    public void push(PushMessage message, MsgUserTokenBean userToken, PushResponseCallback callback) {
        System.setProperty("gexin.rp.sdk.pushlist.needDetails", "true");
        IGtPush push = this.getIgtpush();
        Object template = null;
        template = TemplateTypeEnum.NOTIFCTION.equals((Object)message.getType()) && !this.isios(userToken) ? this.notificationTemplate(message) : this.transmissionTemplate(message, userToken);
        SingleMessage singleMessage = new SingleMessage();
        singleMessage.setOffline(true);
        singleMessage.setOfflineExpireTime((long)(message.getPeriodTime() * 3600 * 1000));
        singleMessage.setData((ITemplate)template);
        singleMessage.setPushNetWorkType(0);
        Target target = new Target();
        target.setAppId(this.appPushProperties.getId());
        if (!StringUtils.isNotBlank((CharSequence)userToken.getToken())) {
            callback.apply(message, userToken, Response.fail("without token"));
            return;
        }
        target.setClientId(userToken.getToken());
        IPushResult ret = push.pushMessageToSingle(singleMessage, target);
        if (null != ret && ret.getResponse() != null) {
            String result = Objects.toString(ret.getResponse().get("result"));
            if ("ok".equalsIgnoreCase(result)) {
                callback.apply(message, userToken, Response.success());
            } else if ("TokenMD5NoUsers".equalsIgnoreCase(result)) {
                callback.apply(message, userToken, Response.expire("token expired"));
            } else {
                this.logger.info("\u63a8\u9001\u5931\u8d25\uff0c\u63a8\u9001\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)ret));
                callback.apply(message, userToken, Response.fail(result));
            }
        } else {
            this.logger.error("\u8c03\u52a8\u4e2a\u63a8API\u5931\u8d25\uff0c\u54cd\u5e94\u5bf9\u8c61\u4e3a\u7a7a");
            callback.apply(message, userToken, Response.fail("failed"));
        }
    }

    private boolean isios(MsgUserTokenBean userDevice) {
        return Objects.equals(PlatformEnum.IOS.getCode(), userDevice.getPlatform());
    }

    private TransmissionTemplate transmissionTemplate(PushMessage pushMessage, MsgUserTokenBean userDevice) {
        TransmissionTemplate template = new TransmissionTemplate();
        template.setAppId(this.appPushProperties.getId());
        template.setAppkey(this.appPushProperties.getKey());
        template.setTransmissionType(2);
        pushMessage.getPayloadInfo().getExtend().put("notifyImageUrl", pushMessage.getNotifyImageUrl());
        pushMessage.getPayloadInfo().getExtend().put("notifyText", pushMessage.getNotifyText());
        template.setTransmissionContent(pushMessage.getPayloadInfo().toJsonString());
        APNPayload payload = this.buildApnPayload(pushMessage);
        if (this.isios(userDevice)) {
            if (pushMessage.getPayloadInfo().getType() == PushMessageEnum.TASK_COMPLETED.getType()) {
                payload.setContentAvailable(1);
            } else {
                payload.setContentAvailable(0);
            }
        }
        template.setAPNInfo((Payload)payload);
        return template;
    }

    private NotificationTemplate notificationTemplate(PushMessage pushMessage) {
        NotificationTemplate template = new NotificationTemplate();
        template.setAppId(this.appPushProperties.getId());
        template.setAppkey(this.appPushProperties.getKey());
        template.setTransmissionType(1);
        pushMessage.getPayloadInfo().getExtend().put("notifyImageUrl", pushMessage.getNotifyImageUrl());
        pushMessage.getPayloadInfo().getExtend().put("notifyText", pushMessage.getNotifyText());
        template.setTransmissionContent(pushMessage.getPayloadInfo().toJsonString());
        APNPayload payload = this.buildApnPayload(pushMessage);
        template.setAPNInfo((Payload)payload);
        Style6 style = new Style6();
        if (PushFoldTypeEnum.IMAGE.equals((Object)pushMessage.getPushFoldType())) {
            style.setBigStyle1(pushMessage.getNotifyImageUrl());
        }
        if (PushFoldTypeEnum.TEXT.equals((Object)pushMessage.getPushFoldType())) {
            style.setBigStyle2(pushMessage.getNotifyText());
        }
        style.setTitle(pushMessage.getTitle());
        style.setText(pushMessage.getContent());
        style.setRing(!pushMessage.isMute());
        style.setVibrate(true);
        style.setClearable(true);
        template.setStyle((AbstractNotifyStyle)style);
        return template;
    }

    private APNPayload buildApnPayload(PushMessage pushMessage) {
        APNPayload payload = new APNPayload();
        payload.setAutoBadge("+1");
        if (TemplateTypeEnum.NOTIFCTION.equals((Object)pushMessage.getType())) {
            payload.setContentAvailable(1);
        } else {
            payload.setContentAvailable(0);
        }
        if (pushMessage.isMute()) {
            payload.setSound(PushSoundEnum.IOS_MUTE.getIosSound());
        } else {
            payload.setSound(pushMessage.getSound().getIosSound());
        }
        APNPayload.DictionaryAlertMsg dictionaryAlertMsg = new APNPayload.DictionaryAlertMsg();
        if (!PushMessageEnum.getMessageSilenceByType((int)pushMessage.getPayloadInfo().getType()).booleanValue()) {
            dictionaryAlertMsg.setTitle(pushMessage.getTitle());
            dictionaryAlertMsg.setBody(pushMessage.getContent());
        } else {
            payload.setContentAvailable(0);
        }
        payload.setAlertMsg((APNPayload.AlertMsg)dictionaryAlertMsg);
        payload.addCustomMsg("payload", (Object)pushMessage.getPayloadInfo().toJsonString());
        return payload;
    }

    private IGtPush getIgtpush() {
        if (null == this.iGtPush) {
            this.iGtPush = new IGtPush(this.appPushProperties.getHost(), this.appPushProperties.getKey(), this.appPushProperties.getMasterSecret());
        }
        return this.iGtPush;
    }
}

