/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.msg.rule.impl;

import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.localnews.msg.integration.UserIntegrationService;
import com.bxm.localnews.msg.rule.IPushRule;
import com.bxm.localnews.msg.vo.UserInfoBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PlaceHolderPushRule
implements IPushRule {
    private static final String USER_NICKNAME = "{nickname}";
    private UserIntegrationService userIntegrationService;

    @Autowired
    public PlaceHolderPushRule(UserIntegrationService userIntegrationService) {
        this.userIntegrationService = userIntegrationService;
    }

    @Override
    public boolean accpect(PushMessage message) {
        if (this.havePlaceholder(message)) {
            this.processPlaceholders(message);
        }
        return true;
    }

    private boolean havePlaceholder(PushMessage message) {
        if (message.getContent() != null && message.getContent().contains(USER_NICKNAME)) {
            return true;
        }
        if (message.getPayloadInfo() != null && message.getPayloadInfo().getContent() != null) {
            return message.getPayloadInfo().getContent().contains(USER_NICKNAME);
        }
        return false;
    }

    private void processPlaceholders(PushMessage message) {
        PushPayloadInfo pushPayloadInfo;
        Long userId = message.getPushReceiveScope().getUserId();
        String nickname = this.loadUserName(userId);
        if (message.getContent() != null) {
            message.setContent(message.getContent().replace(USER_NICKNAME, nickname));
        }
        if (null != (pushPayloadInfo = message.getPayloadInfo()) && null != pushPayloadInfo.getContent()) {
            pushPayloadInfo.setContent(pushPayloadInfo.getContent().replace(USER_NICKNAME, nickname));
            message.setPayloadInfo(pushPayloadInfo);
        }
    }

    private String loadUserName(Long userId) {
        UserInfoBean userInfo = this.userIntegrationService.getUserInfo(userId);
        if (null == userInfo) {
            return "";
        }
        return userInfo.getNickname();
    }
}

