/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.msg.service;

import com.bxm.localnews.mq.common.constant.PushReceiverRuleEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.model.dto.PushReceiveScope;
import com.bxm.localnews.msg.config.AppPushProperties;
import com.bxm.localnews.msg.strategy.IPushDistributeStrategy;
import com.bxm.localnews.msg.strategy.impl.ConditionPushDistributeStrategy;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class PushMessageDispatcher {
    private static final Logger log = LoggerFactory.getLogger(PushMessageDispatcher.class);
    private SequenceCreater sequenceCreater;
    private AppPushProperties appPushProperties;
    private Map<PushReceiverRuleEnum, IPushDistributeStrategy> strategyMap;
    private final ConditionPushDistributeStrategy conditionPushDistributeStrategy;

    @Autowired
    public PushMessageDispatcher(SequenceCreater sequenceCreater, AppPushProperties appPushProperties, List<IPushDistributeStrategy> pushStrategies, ConditionPushDistributeStrategy conditionPushDistributeStrategy) {
        this.sequenceCreater = sequenceCreater;
        this.appPushProperties = appPushProperties;
        this.conditionPushDistributeStrategy = conditionPushDistributeStrategy;
        this.strategyMap = Maps.newHashMap();
        for (IPushDistributeStrategy pushStrategy : pushStrategies) {
            this.strategyMap.put(pushStrategy.support(), pushStrategy);
        }
    }

    public void push(PushMessage message) {
        PushReceiveScope receiveScope;
        this.setDefaultProperty(message);
        if (log.isDebugEnabled()) {
            log.debug("\u6d88\u606f\u63a8\u9001\u5f00\u59cb,message:{}", (Object)message);
        }
        if (null != (receiveScope = message.getPushReceiveScope())) {
            IPushDistributeStrategy pushStrategy = this.strategyMap.getOrDefault(receiveScope.getPushReceiverRule(), this.conditionPushDistributeStrategy);
            pushStrategy.send(message);
        } else {
            log.error("\u6d88\u606f\u672a\u8bbe\u7f6e\u63a5\u6536\u5bf9\u8c61\uff0c\u6d88\u606f\u5185\u5bb9\uff1a{}", (Object)message);
        }
        if (log.isDebugEnabled()) {
            log.debug("\u6d88\u606f\u63a8\u9001\u5230\u6d88\u606f\u961f\u5217\u7ed3\u675f,messageId:{}", (Object)message);
        }
    }

    private void setDefaultProperty(PushMessage message) {
        if (!message.isStatistics() && StringUtils.isEmpty((Object)message.getPayloadInfo().getMsgId())) {
            long msgId = this.sequenceCreater.nextLongId();
            message.getPayloadInfo().addExtend("msgId", (Object)msgId);
            message.getPayloadInfo().setMsgId(Long.valueOf(msgId));
        }
        if (StringUtils.isEmpty((Object)message.getTitle())) {
            message.setTitle(this.appPushProperties.getDefaulPushTitle());
        }
        if (StringUtils.isEmpty((Object)message.getContent())) {
            message.setContent(this.appPushProperties.getDefaultPushContent());
        }
    }
}

