/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.msg.service.impl;

import com.bxm.localnews.mq.common.constant.ActionTypeEnum;
import com.bxm.localnews.mq.common.constant.PlatformTypeEnum;
import com.bxm.localnews.mq.common.constant.PushFoldTypeEnum;
import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.mq.common.constant.PushReceiverRuleEnum;
import com.bxm.localnews.mq.common.constant.TemplateTypeEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.localnews.mq.common.model.dto.PushReceiveScope;
import com.bxm.localnews.msg.vo.MsgGroupPushBean;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class PushMessageHandler {
    public PushMessage generateMessage(MsgGroupPushBean groupPush) {
        PushMessage pushMessage = PushMessage.build().setTitle(groupPush.getTitle()).setContent(groupPush.getContent()).setMute(this.byteToBoolean(groupPush.getIsMute()).booleanValue());
        pushMessage.setType(this.getTemplateType(groupPush.getPushType()));
        pushMessage.setFloatNotify(this.byteToBoolean(groupPush.getIsFloatNotify()).booleanValue());
        pushMessage.setPushFoldType(this.getPushFold(groupPush.getUnfoldType()));
        pushMessage.setPeriodTime(groupPush.getPeriodTime());
        pushMessage.setShock(this.byteToBoolean(groupPush.getIsVibrate()).booleanValue());
        pushMessage.setActionType(groupPush.getActionType());
        if (StringUtils.isNotEmpty((CharSequence)groupPush.getNotifyImgUrl())) {
            pushMessage.setNotifyImageUrl(groupPush.getNotifyImgUrl());
        }
        if (StringUtils.isNotEmpty((CharSequence)groupPush.getNotifyText())) {
            pushMessage.setNotifyText(groupPush.getNotifyText());
        }
        pushMessage.setPayloadInfo(this.getPushInfo(groupPush));
        pushMessage.setPushReceiveScope(this.getPushReceiveScope(groupPush));
        return pushMessage;
    }

    private Boolean byteToBoolean(Byte value) {
        return null != value && value != 0;
    }

    private PushFoldTypeEnum getPushFold(String unfoldType) {
        try {
            return PushFoldTypeEnum.valueOf((String)unfoldType);
        }
        catch (NullPointerException nullPointerException) {
            return PushFoldTypeEnum.TEXT;
        }
    }

    private TemplateTypeEnum getTemplateType(String pushType) {
        try {
            return TemplateTypeEnum.valueOf((String)pushType);
        }
        catch (NullPointerException nullPointerException) {
            return TemplateTypeEnum.NOTIFCTION;
        }
    }

    private PushPayloadInfo getPushInfo(MsgGroupPushBean adminPushMessage) {
        Date now = new Date();
        PushPayloadInfo payloadInfo = PushPayloadInfo.build().setTitle(adminPushMessage.getTitle()).setContent(adminPushMessage.getContent()).setCreateTime(Long.valueOf(now.getTime()));
        payloadInfo.setMsgId(adminPushMessage.getId());
        payloadInfo.addExtend("title", (Object)adminPushMessage.getTitle());
        if (ActionTypeEnum.OPEN_NEWS.getType().equals(adminPushMessage.getActionType())) {
            payloadInfo.setType(PushMessageEnum.NEWS.getType());
            payloadInfo.addExtend("newsId", (Object)adminPushMessage.getActionParams());
            payloadInfo.addExtend("type", (Object)1);
        }
        if (ActionTypeEnum.OPEN_POST.getType().equals(adminPushMessage.getActionType())) {
            payloadInfo.setType(PushMessageEnum.POST.getType());
            payloadInfo.addExtend("postId", (Object)Long.valueOf(adminPushMessage.getActionParams()));
        }
        if (ActionTypeEnum.OPEN_URL.getType().equals(adminPushMessage.getActionType())) {
            payloadInfo.setType(PushMessageEnum.OPEN_URL.getType());
            payloadInfo.setProtocol(adminPushMessage.getActionParams());
            payloadInfo.addExtend("url", (Object)adminPushMessage.getActionParams());
        }
        return payloadInfo;
    }

    private PushReceiveScope getPushReceiveScope(MsgGroupPushBean adminPushMessage) {
        ArrayList platformTypeEnumList = Lists.newArrayList();
        if (StringUtils.isNotEmpty((CharSequence)adminPushMessage.getPushPlatform())) {
            String[] platforms;
            for (String platform : platforms = adminPushMessage.getPushPlatform().split(",")) {
                platformTypeEnumList.add(PlatformTypeEnum.valueOf((String)platform));
            }
        }
        if (adminPushMessage.getPushTarget() == 1) {
            String[] userIds = StringUtils.split((String)adminPushMessage.getTargetUserid(), (String)",");
            return PushReceiveScope.pushGroup(Stream.of(userIds).map(Long::new).collect(Collectors.toList())).setPlatformTypes((List)platformTypeEnumList);
        }
        if (adminPushMessage.getPushTarget() == 2 || adminPushMessage.getPushTarget() == 3) {
            PushReceiveScope pushReceiveScope = PushReceiveScope.pushRule((PushReceiverRuleEnum)PushReceiverRuleEnum.CONDITION).setPlatformTypes((List)platformTypeEnumList);
            String[] areas = StringUtils.split((String)adminPushMessage.getAreaScope(), (String)",");
            if (null != areas && areas.length > 0) {
                pushReceiveScope.addRuleParam("areaCodes", Stream.of(areas).collect(Collectors.toList()));
            }
            pushReceiveScope.addRuleParam("extend", (Object)adminPushMessage.getExtendParams());
            return pushReceiveScope;
        }
        return null;
    }
}

