/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.msg.strategy.impl;

import com.bxm.localnews.mq.common.constant.PushReceiverRuleEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.model.dto.PushReceiveScope;
import com.bxm.localnews.mq.common.param.UserSearchPageParam;
import com.bxm.localnews.msg.integration.UserIntegrationService;
import com.bxm.localnews.msg.strategy.impl.AbstractPushDistributeStrategy;
import com.bxm.newidea.component.thread.NamedThreadFactory;
import com.bxm.newidea.component.vo.PageWarper;
import java.util.Collection;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;

@Component
public class ConditionPushDistributeStrategy
extends AbstractPushDistributeStrategy {
    private static final Logger log = LoggerFactory.getLogger(ConditionPushDistributeStrategy.class);
    @Resource
    private UserIntegrationService userIntegrationService;
    private ThreadPoolTaskExecutor executor;

    @Override
    public PushReceiverRuleEnum support() {
        return PushReceiverRuleEnum.CONDITION;
    }

    @Override
    public void send(PushMessage message) {
        this.execPreprocess(message);
        PageWarper<Long> page = this.queryAndDeal(message, 1);
        if (page.isHasNextPage()) {
            if (null == this.executor) {
                this.initThreadPool();
            }
            AtomicInteger pageNum = new AtomicInteger(1);
            for (int i = 0; i < page.getPages() - 1; ++i) {
                this.executor.execute(() -> this.queryAndDeal(message, pageNum.incrementAndGet()));
            }
        }
    }

    private PageWarper<Long> queryAndDeal(PushMessage message, int pageNum) {
        PageWarper page;
        PushReceiveScope pushReceiveScope = message.getPushReceiveScope();
        UserSearchPageParam pageParam = UserSearchPageParam.builder().pushReceiverRule(pushReceiveScope.getPushReceiverRule()).ruleParam(pushReceiveScope.getRuleParam()).build();
        int pageSize = this.appPushProperties.getBucketNum() * this.appPushProperties.getPullMultiple();
        pageParam.setPageSize(Integer.valueOf(pageSize));
        pageParam.setPageNum(Integer.valueOf(pageNum));
        if (log.isDebugEnabled()) {
            log.debug("\u5206\u9875\u83b7\u53d6\u63a8\u9001\u76ee\u6807\u6570\u636e\uff0c\u6bcf\u9875\u6570\u91cf:{}\uff0c\u5f53\u524d\u9875:{}", (Object)pageSize, (Object)pageNum);
        }
        if (CollectionUtils.isNotEmpty((Collection)(page = this.userIntegrationService.queryUserByPage(pageParam)).getList())) {
            this.splitTask(page.getList(), message.getMsgId(), pageNum, page.getPages());
        }
        return page;
    }

    private void initThreadPool() {
        this.executor = new ThreadPoolTaskExecutor();
        this.executor.setCorePoolSize(2);
        this.executor.setQueueCapacity(10000);
        this.executor.setMaxPoolSize(10);
        this.executor.setKeepAliveSeconds(10);
        this.executor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.AbortPolicy());
        this.executor.setThreadFactory((ThreadFactory)new NamedThreadFactory("batch-page-push"));
        this.executor.initialize();
    }
}

