/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.msg.timer;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.msg.config.PushMessageStatusEnum;
import com.bxm.localnews.msg.param.PushMsgBuildParam;
import com.bxm.localnews.msg.service.MessageGroupService;
import com.bxm.localnews.msg.service.PushMessageDispatcher;
import com.bxm.localnews.msg.vo.MsgGroupPushBean;
import com.bxm.newidea.component.schedule.task.AbstractTaskCallback;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.xxl.job.core.biz.model.ReturnT;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PushMessageTask
extends AbstractTaskCallback<PushMsgBuildParam> {
    private static final Logger log = LoggerFactory.getLogger(PushMessageTask.class);
    @Resource
    private PushMessageDispatcher pushMessageDispatcher;
    private MessageGroupService messageGroupService;

    private MessageGroupService getMessageGroupService() {
        if (this.messageGroupService == null) {
            this.messageGroupService = (MessageGroupService)SpringContextHolder.getBean(MessageGroupService.class);
        }
        return this.messageGroupService;
    }

    protected ReturnT<String> service(PushMsgBuildParam param) {
        log.debug("\u5b9a\u65f6\u63a8\u9001\u5f00\u59cb\u6267\u884c:{}", (Object)JSON.toJSONString((Object)((Object)this)));
        Long messageId = param.getMessageId();
        PushMessage pushMessage = param.getPushMessage();
        MsgGroupPushBean groupPushBean = this.getMessageGroupService().get(messageId);
        byte status = groupPushBean.getStatus();
        if (PushMessageStatusEnum.STAY_CONFIRM.getType().equals(status)) {
            log.warn("\u6d88\u606fID[{}]\u5df2\u53d6\u6d88\u63a8\u9001", (Object)messageId);
            return ReturnT.SUCCESS;
        }
        if (PushMessageStatusEnum.BEING_SEND.getType().equals(status)) {
            log.warn("\u6d88\u606fID[{}]\u6b63\u5728\u63a8\u9001\u4e2d", (Object)messageId);
            return ReturnT.SUCCESS;
        }
        if (PushMessageStatusEnum.HAS_BEEN_SEND.getType().equals(status)) {
            return ReturnT.SUCCESS;
        }
        log.debug("\u6267\u884c\u6d88\u606f\u63a8\u9001,\u63a8\u9001\u6d88\u606fID:[{}],\u63a8\u9001\u6d88\u606f\u5bf9\u8c61\uff1a[{}]", (Object)messageId, (Object)pushMessage);
        this.pushMessageDispatcher.push(pushMessage);
        return ReturnT.SUCCESS;
    }

    public static String generateTaskName(Long messageId) {
        return "pushMessageTask_" + messageId;
    }
}

