package com.bxm.localnews.msg.push;

import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.msg.vo.MsgUserTokenBean;

/**
 * 推送响应结果回调
 *
 * @author liujia
 * @date 2020-07-06 13:58
 **/
@FunctionalInterface
public interface PushResponseCallback {

    /**
     * 执行回调处理
     *
     * @param message   推送内容
     * @param userToken 用户token信息
     * @param response  回调响应内容
     */
    void apply(PushMessage message, MsgUserTokenBean userToken, Response response);
}
