package com.bxm.localnews.msg.timer;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.msg.config.PushMessageStatusEnum;
import com.bxm.localnews.msg.param.PushMsgBuildParam;
import com.bxm.localnews.msg.service.MessageGroupService;
import com.bxm.localnews.msg.service.PushMessageDispatcher;
import com.bxm.localnews.msg.vo.MsgGroupPushBean;
import com.bxm.newidea.component.schedule.task.AbstractTaskCallback;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.xxl.job.core.biz.model.ReturnT;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * 定时推送相关任务
 *
 * @author liujia
 */
@Component
@Slf4j
public class PushMessageTask extends AbstractTaskCallback<PushMsgBuildParam> {

    @Resource
    private PushMessageDispatcher pushMessageDispatcher;

    private MessageGroupService messageGroupService;

    private MessageGroupService getMessageGroupService() {
        if (messageGroupService == null) {
            messageGroupService = SpringContextHolder.getBean(MessageGroupService.class);
        }

        return messageGroupService;
    }

    @Override
    protected ReturnT<String> service(PushMsgBuildParam param) {
        log.info("定时推送开始执行:{}", JSON.toJSONString(param));

        Long messageId = param.getMessageId();
        PushMessage pushMessage = param.getPushMessage();

        MsgGroupPushBean groupPushBean = getMessageGroupService().get(messageId);

        byte status = groupPushBean.getStatus();

        if (PushMessageStatusEnum.CANCEL.getType().equals(status)) {
            log.warn("消息ID[{}]已取消推送", messageId);
            return ReturnT.SUCCESS;
        }
        if (PushMessageStatusEnum.BEING_SEND.getType().equals(status)) {
            log.warn("消息ID[{}]正在推送中", messageId);
            return ReturnT.SUCCESS;
        }
        if (PushMessageStatusEnum.HAS_BEEN_SEND.getType().equals(status)) {
            log.warn("消息ID[{}]已推送，无需重复推送", messageId);
            return ReturnT.SUCCESS;
        }

        // 更新为推送中
        getMessageGroupService().changeStatus(messageId, PushMessageStatusEnum.BEING_SEND);

        log.debug("执行消息推送,推送消息ID:[{}],推送消息对象：[{}]", messageId, pushMessage);
        pushMessageDispatcher.push(pushMessage);

        return ReturnT.SUCCESS;
    }

    public static String generateTaskName(Long messageId) {
        return "pushMessageTask_" + messageId;
    }

}
