package com.bxm.localnews.mq.config;

import com.aliyun.openservices.ons.api.bean.ProducerBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Properties;

/**
 * 阿里云消息队列配置
 * @author liujia 2018/7/27 14:25
 */
@Component
@Configuration
@ConditionalOnProperty(prefix = "aliyun.mq", value = "access-key")
@EnableConfigurationProperties(AliyunMqProperties.class)
@Profile({"test", "prod"})
public class AliyunMqProduceConfiguration {

    @Resource
    private AliyunMqProperties aliyunMqProperties;

    @Bean(name = "producer", initMethod = "start", destroyMethod = "shutdown")
    public ProducerBean producerBean() {
        ProducerBean producerBean = new ProducerBean();

        Properties properties = new Properties();
        properties.setProperty("ProducerId", this.aliyunMqProperties.getProducerId());
        properties.setProperty("AccessKey", this.aliyunMqProperties.getAccessKey());
        properties.setProperty("SecretKey", this.aliyunMqProperties.getAccessSecret());

        producerBean.setProperties(properties);

        return producerBean;
    }

    @Bean(name = "mpProducer", initMethod = "start", destroyMethod = "shutdown")
    public ProducerBean mpProducer() {
        ProducerBean producerBean = new ProducerBean();

        Properties properties = new Properties();
        properties.setProperty("ProducerId", this.aliyunMqProperties.getMpProducerId());
        properties.setProperty("AccessKey", this.aliyunMqProperties.getAccessKey());
        properties.setProperty("SecretKey", this.aliyunMqProperties.getAccessSecret());

        producerBean.setProperties(properties);

        return producerBean;
    }

    /**
     * 短信生产者
     * @return
     */
    @Bean(name = "smsProducer", initMethod = "start", destroyMethod = "shutdown")
    public ProducerBean smsProducer() {
        ProducerBean producerBean = new ProducerBean();

        Properties properties = new Properties();
        properties.setProperty("ProducerId", this.aliyunMqProperties.getSmsProducerId());
        properties.setProperty("AccessKey", this.aliyunMqProperties.getAccessKey());
        properties.setProperty("SecretKey", this.aliyunMqProperties.getAccessSecret());

        producerBean.setProperties(properties);

        return producerBean;
    }

    /**
     * 推送消息生产者
     * @return
     */
    @Bean(name = "pushProducer", initMethod = "start", destroyMethod = "shutdown")
    public ProducerBean pushProducer() {
        ProducerBean producerBean = new ProducerBean();

        Properties properties = new Properties();
        properties.setProperty("ProducerId", this.aliyunMqProperties.getPushProducerId());
        properties.setProperty("AccessKey", this.aliyunMqProperties.getAccessKey());
        properties.setProperty("SecretKey", this.aliyunMqProperties.getAccessSecret());

        producerBean.setProperties(properties);

        return producerBean;
    }
}
