package com.bxm.localnews.mq.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * app消息推送
 * @author liujia 2018/7/26 16:27
 */
@Component
@ConfigurationProperties(prefix = "message.app.push")
@Data
public class AppPushProperties {

    private String id;

    private String secret;

    private String key;

    private String masterSecret;

    private String host;

    /**
     * 华为请求accessToken的地址
     */
    private String huaweiAccessTokenUrl;

    /**
     * 华为API请求地址
     */
    private String huaweiApiUrl;

    /**
     * 华为密钥
     */
    private String huaweiClientSecret;

    /**
     * 华为AppId
     */
    private String huaweiAppId;

    /**
     * android推送需要的app包名称
     */
    private String appPkgName;

    /**
     * 是否使用小米沙箱,true表示使用
     */
    private boolean miuiSandbox;

    /**
     * 小米推送的app id
     */
    private String miuiAppId;

    /**
     * 小米推送的app secret
     */
    private String miuiAppSecret;
}
