package com.bxm.localnews.mq.consume.push.platform.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.mq.common.constant.PlatformTypeEnum;
import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.mq.common.constant.TemplateTypeEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.config.AppPushProperties;
import com.bxm.localnews.msg.vo.UserDeviceBean;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.xiaomi.xmpush.server.Constants;
import com.xiaomi.xmpush.server.Message;
import com.xiaomi.xmpush.server.Result;
import com.xiaomi.xmpush.server.Sender;
import org.json.simple.parser.ParseException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.util.List;

@Component
public class MiuiPushPlatform extends AbstractPushPlatform {

    private final AppPushProperties appPushProperties;

    @Autowired
    public MiuiPushPlatform(AppPushProperties appPushProperties) {
        this.appPushProperties = appPushProperties;
    }

    @Override
    void singlePush(PushMessage pushMessage, UserDeviceBean userDevice) {
        groupPush(pushMessage, ImmutableList.of(userDevice));
    }

    @Override
    void groupPush(PushMessage pushMessage, List<UserDeviceBean> userDeviceList) {
        Constants.useOfficial();

        Sender sender = new Sender(appPushProperties.getMiuiAppSecret());

        String title = pushMessage.getTitle();
        if (title.length() > 50) {
            title = title.substring(0, 47) + "...";
        }

        String description = pushMessage.getContent();
        if (description.length() > 128) {
            description = description.substring(0, 128);
        }

        Message.Builder messageBuilder = new Message.Builder()
                .title(title)
                .description(description)
                .timeToLive(pushMessage.getPeriodTime() * 3600000)
                .payload(JSONObject.toJSONString(pushMessage.getPayloadInfo()))
                .restrictedPackageName(appPushProperties.getAppPkgName());

        if (PushMessageEnum.NEWS.getType() == pushMessage.getPayloadInfo().getType()) {
            String newsId = (String) pushMessage.getPayloadInfo().getExtend().get("newsId");
            String intent = "intent:#Intent;component=com.bxm.localmastercard/.ui.news.NewsDetailActivity;S.0x0008=" + newsId +
                    ";S.0x0022=MainActivity;end";
            messageBuilder.extra(Constants.EXTRA_PARAM_INTENT_URI, intent);
        }

        if (TemplateTypeEnum.NOTIFCTION.equals(pushMessage.getType())) {
            messageBuilder.passThrough(0);
        } else {
            messageBuilder.passThrough(1);
        }

        if (pushMessage.isMute()) {
            messageBuilder.notifyType(0);
        } else if (pushMessage.isShock()) {
            messageBuilder.notifyType(1 | 2);
        } else {
            messageBuilder.notifyType(1);
        }

        try {
            List<String> regIdList = Lists.newArrayList();
            for (UserDeviceBean userDevice : userDeviceList) {
                regIdList.add(userDevice.getPushToken());
            }
            Result result = sender.send(messageBuilder.build(), regIdList, 3);

            logger.debug("小米推送完成，推送结果：{}", result);
            callback(pushMessage, userDeviceList, result.getErrorCode().getValue() + ":" + result.getReason());
        } catch (IOException | ParseException e) {
            logger.error(e.getMessage(), e);
        }

    }

    @Override
    public PlatformTypeEnum getType() {
        return PlatformTypeEnum.MIUI;
    }
}
