package com.bxm.localnews.mq.consume.push.receive.impl;

import com.bxm.localnews.mq.common.constant.PlatformTypeEnum;
import com.bxm.localnews.mq.consume.push.receive.IReceiveUserIterator;
import com.bxm.localnews.msg.domain.UserDeviceMapper;
import com.bxm.localnews.msg.vo.UserDeviceBean;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.springframework.util.StringUtils;

import java.util.List;
import java.util.Map;

public abstract class AbstractReceiveUserIterator implements IReceiveUserIterator {

    /**
     * 每页用户数量
     */
    int pageSize = 1000;

    /**
     * 用户获取需要使用的相关参数
     */
    Map<String, Object> paramMap;

    UserDeviceMapper userDeviceMapper;

    /**
     * 数量总数
     */
    private int total = -1;

    /**
     * 当前页
     */
    private int currentPage = 0;

    @Override
    public boolean hasNext() {
        if (total == -1) {
            total = getTotal();
        }
        return (total - currentPage * pageSize) > 0;
    }

    @Override
    public Map<PlatformTypeEnum, List<UserDeviceBean>> next() {
        List<UserDeviceBean> userList = queryByPage(currentPage);

        Map<PlatformTypeEnum, List<UserDeviceBean>> userMap = Maps.newHashMap();

        for (UserDeviceBean user : userList) {
            PlatformTypeEnum type = null;
            //如果不存在指定的推送平台则默认使用个推进行推送
            if (StringUtils.isEmpty(user.getPlatform())) {
                type = PlatformTypeEnum.GETUI;
            } else {
                type = PlatformTypeEnum.valueOf(user.getPlatform());
            }

            List<UserDeviceBean> users = userMap.get(type);
            if (null == users) {
                users = Lists.newArrayList();
            }
            users.add(user);
            userMap.put(type, users);
        }

        currentPage++;
        return userMap;
    }

    @Override
    public IReceiveUserIterator setUserDeviceMapper(UserDeviceMapper userDeviceMapper) {
        this.userDeviceMapper = userDeviceMapper;
        return this;
    }

    /**
     * 获取用户的总数
     * @return 符合条件的用户总数
     */
    abstract int getTotal();

    /**
     * 分页获取用户数量
     * @param pageNum 页数
     * @return 一页用户数据
     */
    abstract List<UserDeviceBean> queryByPage(int pageNum);
}
