package com.bxm.localnews.mq.produce.service;

import com.bxm.localnews.mq.common.constant.SmsTemplateEnum;
import com.bxm.localnews.mq.common.model.dto.SendSmsResult;

import java.util.List;

/**
 * Created by Arei on 2018/10/11.
 * 提供短信服务，包括短信单发(1.按模版发送2.自定义内容3.发送验证码类模版)，群发，
 *
 * @author Arei
 */
public interface SmsSupplyService {
    /**
     * 按模版发送单条短信
     *
     * @param phoneNo     手机号
     * @param smsTemplate 短信模版
     * @param params      模版对应传入参数
     * @return 短信发送记录id
     */
    SendSmsResult sendSmsByTemplate(String phoneNo, SmsTemplateEnum smsTemplate, String ip, String... params);

    /**
     * 自定义内容发送单条短信
     *
     * @param phoneNo    手机号
     * @param smsContent 自定义短信内容
     * @return 短信发送记录id
     */
    SendSmsResult sendSmsByCustomize(String phoneNo, String smsContent);

    /**
     * 按模版发送多条短信
     *
     * @param phoneNos    手机号列表
     * @param smsTemplate 短信模版
     * @param params      模版对应传入参数
     */
    void sendGroupSmsByTemplate(List<String> phoneNos, SmsTemplateEnum smsTemplate, String... params);

    /**
     * 自定义内容发送多条短信
     *
     * @param phoneNos   手机号列表
     * @param smsContent 自定义短信内容
     */
    void sendGroupSmsByCustomize(List<String> phoneNos, String smsContent);

    /**
     * 验证短信验证码
     *
     * @param phoneNo
     * @param code
     * @param smsTemplate
     */
    Boolean verifySmsCode(String phoneNo, String code, SmsTemplateEnum smsTemplate);

    Boolean verifySmsCodeByType(Byte type, String phoneNo, String code);

    /**
     * 发送验证码类模版且只支持验证码类模版
     *
     * @param phoneNo
     * @param smsTemplateEnum
     * @param ip
     * @return
     */
    SendSmsResult sendSmsByVCodeTemplate(String phoneNo, SmsTemplateEnum smsTemplateEnum, String ip);
}
