package com.bxm.localnews.mq.produce.service.impl;

import com.bxm.localnews.mq.common.constant.AliMqMsgTagEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.produce.service.AliMqService;
import com.bxm.localnews.mq.produce.service.PushMsgSupplyService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * Created by Arei on 2018/10/12.
 */
@Service("pushMsgSupplyService")
public class PushMsgSupplyServiceImpl implements PushMsgSupplyService {
    private static final Logger logger = LoggerFactory.getLogger(PushMsgSupplyServiceImpl.class);

    @Resource
    private AliMqService aliMqService;

    @Override
    public void pushMsg(PushMessage message) {
        aliMqService.send(aliMqService.createMessage(AliMqMsgTagEnum.PUSH, message));
    }
    // TODO [liujia]逻辑修改，进行消费时才同步到用户
    //    private int saveMsg(Message msg) {
    //
    //        int result = messageMapper.insertSelective(msg);
    //
    //        //通知红点设置
    //        KeyGenerator redPointKey = RedisConfig.MSG_RED_POINT.copy().appendKey(msg.getUserId());
    //        redisStringAdapter.set(redPointKey, true);
    //
    //        return result;
    //    }
    //
    //
    //    private void batchSaveMessage(Set<String> userIds, Message message) {
    //        List<Message> messageList = new ArrayList<>();
    //        for (String userId : userIds) {
    //            Message msg = new Message();
    //            BeanUtils.copyProperties(message, msg);
    //            msg.setUserId(Long.valueOf(userId));
    //            messageList.add(msg);
    //        }
    //
    //        new BatchHelper<MessageMapper, Message>(MessageMapper.class, messageList) {
    //            @Override
    //            protected int invoke(Message element) {
    //                int result = this.domain.insertSelective(element);
    //
    //                //通知红点设置
    //                KeyGenerator redPointKey = RedisConfig.MSG_RED_POINT.copy().appendKey(element.getUserId());
    //                redisStringAdapter.set(redPointKey, true);
    //
    //                return result;
    //            }
    //        };
    //
    //    }
}
