package com.bxm.localnews.msg.common;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.impl.DefaultKeyGenerator;

/**
 * redis 缓存的key值，格式为： {业务类型：模块：子模块:更下级模块}
 * 业务类型： biz:业务  config:配置
 */
public class RedisConfig {

    /**
     * ============================= message模块 ==============================
     */
    /**
     * 短信相关RedisKey模版
     */
    public static KeyGenerator MESSAGE_SMS = DefaultKeyGenerator.build("message", "sms");

    /**
     * 2.5.1 用户未读的消息类型与数量
     */
    public static KeyGenerator UN_READ_MSG = DefaultKeyGenerator.build("message", "unread");

    /**
     * 2.5.1 用户各种类型的最后一条未读消息
     */
    public static KeyGenerator LAST_MSG = DefaultKeyGenerator.build("message", "last");

    /**
     * 华为推送的访问token
     */
    public static KeyGenerator HUAWEI_ACCESS_TOKEN = DefaultKeyGenerator.build("message", "cache", "huaweitoken");

    /**
     * 华为推送的访问token过期时间
     */
    public static KeyGenerator HUAWEI_ACCESS_TOKEN_EXPIRED = DefaultKeyGenerator.build("message", "cache", "huaweitoken").appendKey("expired");

    /**
     * 2.5.1 用户的最后一条互动消息记录
     * 每一个时间段存储一份（当前逻辑为半小时），ttl：60*60s
     */
    public static KeyGenerator LAST_INTERACTION_MSG = DefaultKeyGenerator.build("message", "interaction");

    /**
     * 2.5.1 用户互动消息总数
     * 每一个时间段存储一份（当前逻辑为半小时），ttl：60*60s
     */
    public static KeyGenerator INTERACTION_NUM = DefaultKeyGenerator.build("message", "interaction", "num");


    /**
     * ======================== user模块 事件 ==========================
     */

    /**
     * 用户的缓存通知事件
     */
    public static KeyGenerator USER_EVENTS = DefaultKeyGenerator.build("user", "cache", "events");

    /**
     * 有未消费事件的用户ID
     */
    public static KeyGenerator HAS_EVENT_SET = DefaultKeyGenerator.build("user", "cache", "hasevent");

    /**
     * =================================== user 模块相关缓存键值 用户信息 ===================================
     */
    public static KeyGenerator USER_INFO = DefaultKeyGenerator.build("user", "cache", "userInfo");
}
