package com.bxm.localnews.msg.config;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * 短信发送配置
 * @author liujia 2018/7/26 16:37
 */
@Component
@ConfigurationProperties("message.config")
public class MessageProperties {

    /**
     * 示远短信发送请求路径
     */
    private String shiyuanUrl;

    /**
     * 示远短信账号
     */
    private String shiyuanAccount;

    /**
     * 示远短信密码
     */
    private String shiyuanPwd;

    /**
     * 235云通讯短信请求路径
     */
    private String chuanglanUrl;

    /**
     * 235云通讯短信账号
     */
    private String chuanglanAccount;

    /**
     * 235云通讯短信密码
     */
    private String chuanglanPwd;

    /**
     * 是否启用发送验证码
     */
    private Boolean enableSms;

    public String getShiyuanAccount() {
        return shiyuanAccount;
    }

    public void setShiyuanAccount(String shiyuanAccount) {
        this.shiyuanAccount = shiyuanAccount;
    }

    public String getShiyuanPwd() {
        return shiyuanPwd;
    }

    public void setShiyuanPwd(String shiyuanPwd) {
        this.shiyuanPwd = shiyuanPwd;
    }

    public Boolean getEnableSms() {
        return enableSms;
    }

    public void setEnableSms(Boolean enableSms) {
        this.enableSms = enableSms;
    }

    public String getShiyuanUrl() {
        return shiyuanUrl;
    }

    public void setShiyuanUrl(String shiyuanUrl) {
        this.shiyuanUrl = shiyuanUrl;
    }

    public String getChuanglanUrl() {
        return chuanglanUrl;
    }

    public void setChuanglanUrl(String chuanglanUrl) {
        this.chuanglanUrl = chuanglanUrl;
    }

    public String getChuanglanAccount() {
        return chuanglanAccount;
    }

    public void setChuanglanAccount(String chuanglanAccount) {
        this.chuanglanAccount = chuanglanAccount;
    }

    public String getChuanglanPwd() {
        return chuanglanPwd;
    }

    public void setChuanglanPwd(String chuanglanPwd) {
        this.chuanglanPwd = chuanglanPwd;
    }
}
