package com.bxm.localnews.msg.config;

import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.msg.constant.MessageTypeEnum;
import com.bxm.localnews.msg.vo.MessageType;
import com.bxm.newidea.component.tools.StringUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * @author zhaoyadong 2019/4/8 13:56
 * @desc
 */
@Component
@ConfigurationProperties("message.config.message")
public class MessageTypeProperties {

    /**
     * 消息类型标题
     */
    private List<String> typeTitle = Lists.newArrayList();

    /**
     * 消息类型列表
     */
    private List<String> typeName = Lists.newArrayList();

    /**
     * 消息图标列表
     */
    private List<String> typeImg = Lists.newArrayList();

    private Map<String, String> type = Maps.newHashMap();

    private Map<String, List<String>> msgTypeMap = Maps.newHashMap();

    /**
     * 模板消息推送的类型列表
     */
    private String template;

    /**
     * 转换类型
     */
    private List<Integer> templateList = Lists.newArrayList();

    /**
     * 互动消息类型
     */
    private List<String> interactionList = Lists.newArrayList();

    private Map<String, MessageType> messageInfoMap;

    public MessageType getMessageInfo(String msgType) {
        if (messageInfoMap == null) {
            messageInfoMap = Maps.newHashMap();

            int index = 0;
            for (String type : getTypeName()) {
                MessageType messageType = new MessageType();
                messageType.setMessageType(type);
                messageType.setImg(getTypeImg().get(index));
                messageType.setTitle(getTypeTitle().get(index));

                messageInfoMap.put(type, messageType);
                index++;
            }
        }

        return messageInfoMap.get(msgType);
    }

    public List<String> getTypeTitle() {
        return typeTitle;
    }

    public void setTypeTitle(List<String> typeTitle) {
        this.typeTitle = typeTitle;
    }

    public List<String> getTypeName() {
        return typeName;
    }

    public void setTypeName(List<String> typeName) {
        this.typeName = typeName;
    }

    public List<String> getTypeImg() {
        return typeImg;
    }

    public void setTypeImg(List<String> typeImg) {
        this.typeImg = typeImg;
    }

    public Map<String, String> getType() {
        return type;
    }

    public void setType(Map<String, String> type) {
        this.type = type;
        Iterator<Map.Entry<String, String>> iterator = type.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            msgTypeMap.put(entry.getKey(), Stream.of(StringUtils.split(entry.getValue(), ","))
                    .collect(Collectors.toList()));
        }
    }

    public Map<String, List<String>> getMsgTypeMap() {
        return msgTypeMap;
    }

    /**
     * 将推送的消息类型转换为消息中心对应的栏目
     * @param pushMsgType 推送消息类型
     * @return 消息中心栏目类型，详见{@link MessageTypeEnum}
     */
    public String convertType(Object pushMsgType) {
        String type = Objects.toString(pushMsgType);

        if (String.valueOf(PushMessageEnum.ADD_FUNS.getType()).equals(type)) {
            return PushMessageEnum.ADD_FUNS.name();
        }

        if (String.valueOf(PushMessageEnum.IM_MESSAGE.getType()).equals(type)) {
            return PushMessageEnum.IM_MESSAGE.name();
        }

        for (Map.Entry<String, List<String>> entry : msgTypeMap.entrySet()) {
            if (entry.getValue().contains(type)) {
                return entry.getKey();
            }
        }

        return pushMsgType.toString();
    }

    public static void main(String[] args) {
        MessageTypeProperties messageTypeProperties = new MessageTypeProperties();
        System.out.println(messageTypeProperties.convertType(99));
    }

    /**
     * 消息类型是否为互动消息
     * @param msgType 消息类型
     * @return true表示为互动消息
     */
    public boolean isInteraction(String msgType) {
        return MessageTypeEnum.COMMENT.name().equals(msgType)
                || MessageTypeEnum.LIKE.name().equals(msgType)
                || MessageTypeEnum.INVITE.name().equals(msgType)
                || MessageTypeEnum.SHARE.name().equals(msgType);
    }

    public String getTemplate() {
        return template;
    }

    public void setTemplate(String template) {
        this.template = template;
        templateList = Stream.of(StringUtils.split(template, ",")).map(Integer::new).collect(Collectors.toList());
    }

    public boolean isAppletTemplateType(int type) {
        return templateList.contains(type);
    }

    public List<Integer> getTemplateList() {
        return templateList;
    }

    public void setTemplateList(List<Integer> templateList) {
        this.templateList = templateList;
    }

    public List<String> getInteractionList() {
        return interactionList;
    }

    public void setInteractionList(List<String> interactionList) {
        this.interactionList = interactionList;
    }
}
