package com.bxm.localnews.msg.config;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * Created by Arei on 2018/10/11.
 * 短信常用配置，支持热更新
 * @author Arei
 */
@Component
@ConfigurationProperties("message.config")
public class SmsLimnitConfig {

    /**
     * 单个模版每个ip每天的限制发送量
     */
    private Integer ipLimitPerDay;

    /**
     * 单个模版每个电话每天的限制发送量
     */
    private Integer phoneLimitPerDay;

    public Integer getIpLimitPerDay() {
        return ipLimitPerDay;
    }

    public void setIpLimitPerDay(Integer ipLimitPerDay) {
        this.ipLimitPerDay = ipLimitPerDay;
    }

    public Integer getPhoneLimitPerDay() {
        return phoneLimitPerDay;
    }

    public void setPhoneLimitPerDay(Integer phoneLimitPerDay) {
        this.phoneLimitPerDay = phoneLimitPerDay;
    }
}
