package com.bxm.localnews.msg.consumer.impl;

import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.ons.api.Action;
import com.aliyun.openservices.ons.api.ConsumeContext;
import com.aliyun.openservices.ons.api.Message;
import com.bxm.localnews.mq.common.constant.MQConstant;
import com.bxm.localnews.msg.facade.NewsSyncFeignService;
import com.bxm.localnews.msg.param.NewsStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

import static com.bxm.localnews.mq.common.constant.MQConstant.TAG.SHARE_KEY;

@Component
public class NewsShareConsumer extends AbstractNewsActionMessageConsumer {

    private static final Logger LOGGER = LoggerFactory.getLogger(NewsShareConsumer.class);

    @Autowired
    NewsSyncFeignService newsSyncFeignService;

    @Override
    public boolean support(String tag) {
        return SHARE_KEY.equals(tag);
    }

    @Override
    public Action consume(Message message, ConsumeContext context) {
        try {
            this.newsShare(message);
        } catch (Exception e) {
            LOGGER.warn(e.getMessage(), e);
            return Action.ReconsumeLater;
        }
        LOGGER.debug("消费成功，消息内容：" + message);
        return Action.CommitMessage;
    }

    private void newsShare(Message message) {
        JSONObject body = getMsgBody(message);
        //Long userId = Long.valueOf(body.getString(MQConstant.NEW_CLICK_KEY.USER_ID));
        Long newsId = Long.valueOf(body.getString(MQConstant.NEW_CLICK_KEY.NEWS_ID));

        NewsStatistics newsStatistics = new NewsStatistics();
        newsStatistics.setShares(1);
        newsStatistics.setNewsId(newsId);

        List<NewsStatistics> newsStatisticsList = new ArrayList<>();
        newsStatisticsList.add(newsStatistics);

        newsSyncFeignService.updateStatistic(newsStatisticsList);

        LOGGER.debug("进行消费");
    }

}
