package com.bxm.localnews.msg.consumer.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.ons.api.Action;
import com.aliyun.openservices.ons.api.ConsumeContext;
import com.aliyun.openservices.ons.api.Message;
import com.bxm.localnews.msg.facade.NewsFeignService;
import com.bxm.localnews.msg.param.VideoBlackParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import static com.bxm.localnews.mq.common.constant.MQConstant.TAG.VIDEO_BLACK_KEY;

@Component
public class VideoBlackConsumer extends AbstractNewsActionMessageConsumer {

    private static final Logger LOGGER = LoggerFactory.getLogger(VideoBlackConsumer.class);

    @Autowired
    NewsFeignService newsFeignService;


    @Override
    public boolean support(String tag) {
        return VIDEO_BLACK_KEY.equals(tag);
    }

    @Override
    public Action consume(Message message, ConsumeContext context) {
        try {
            this.newsViews(message);
        } catch (Exception e) {
            LOGGER.warn(e.getMessage(), e);
            return Action.ReconsumeLater;
        }
        LOGGER.debug("小视频屏蔽消费成功，消息内容：" + message);
        return Action.CommitMessage;
    }

    private void newsViews(Message message) {
        JSONObject body = getMsgBody(message);
        VideoBlackParam videoBlackParam = JSON.toJavaObject(body, VideoBlackParam.class);
        newsFeignService.videoBlackConsume(videoBlackParam);
    }

}
