package com.bxm.localnews.msg.dingtalk.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.component.httpclient.service.HttpClientService;
import com.bxm.localnews.msg.config.DingtalkProperties;
import com.bxm.localnews.msg.dingtalk.DingtalkPushService;
import com.bxm.newidea.component.service.BaseService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;

@Service
@RefreshScope
public class DingtalkPushServiceImpl extends BaseService implements DingtalkPushService {

    private final DingtalkProperties dingtalkProperties;

    private final HttpClientService httpClientService;

    @Autowired
    public DingtalkPushServiceImpl(DingtalkProperties dingtalkProperties,
                                   HttpClientService httpClientService) {
        this.dingtalkProperties = dingtalkProperties;
        this.httpClientService = httpClientService;
    }

    @Override
    public void pushNews(String content) {
        JSONObject text = new JSONObject();
        text.put("content", content);

        JSONObject msg = new JSONObject();
        msg.put("msgtype", "text");
        msg.put("text", text);

        String response = httpClientService.doPostJson(dingtalkProperties.getNewsGroupWebhook(), msg.toJSONString());
        logger.debug("push content:[{}],response:[{}]", content, response);
    }

    @Override
    public void pushIM(String content) {
        JSONObject text = new JSONObject();
        text.put("content", content);

        JSONObject msg = new JSONObject();
        msg.put("msgtype", "text");
        msg.put("text", text);

        String response = httpClientService.doPostJson(dingtalkProperties.getImGroupWebhook(), msg.toJSONString());
        logger.debug("push content:[{}],response:[{}]", content, response);
    }
}
