package com.bxm.localnews.msg.listener;

import com.aliyun.openservices.ons.api.Action;
import com.aliyun.openservices.ons.api.ConsumeContext;
import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.MessageListener;
import com.bxm.localnews.mq.common.constant.AliMqMsgTagEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.msg.push.PushMessageDispatcher;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Optional;

import static com.bxm.localnews.mq.common.constant.AliMqMsgTagEnum.PUSH;

/**
 * 推送消息处理监听器
 * @author Arei
 */
@Component
public class PushMessageListener implements MessageListener {
    private static final Logger logger = LoggerFactory.getLogger(PushMessageListener.class);

    @Resource
    private PushMessageDispatcher pushMessageDispatcher;

    @Resource
    private ObjectMapper objectMapper;

    @Override
    public Action consume(Message message, ConsumeContext consumeContext) {
        try {
            String msg = new String(message.getBody());
            PushMessage pushMessage = objectMapper.readValue(msg, PushMessage.class);

            if (null == pushMessage || !pushMessage.valid()) {
                logger.error("message parse failed:{}", message);
                return Action.CommitMessage;
            }

            Optional<AliMqMsgTagEnum> tagEnumOptional = AliMqMsgTagEnum.getTagEnumByTag(message.getTag());
            if (tagEnumOptional.isPresent() && PUSH.equals(tagEnumOptional.get())) {
                pushMessageDispatcher.push(pushMessage);
                return Action.CommitMessage;
            }
            logger.error("illegal tag,messgea:{}", message);
            return Action.ReconsumeLater;
        } catch (Exception e) {
            //消费失败
            logger.error("message consume failed:{}", message);
            logger.error(e.getMessage(), e);

            return Action.ReconsumeLater;
        }
    }
}
