package com.bxm.localnews.msg.listener;

import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.ons.api.Action;
import com.aliyun.openservices.ons.api.ConsumeContext;
import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.MessageListener;
import com.bxm.localnews.mq.common.constant.AppConst;
import com.bxm.localnews.msg.config.MessageProperties;
import com.bxm.localnews.msg.config.SmsOperatorConfig;
import com.bxm.localnews.msg.service.SmsFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * Created by Arei on 2018/10/12.
 * 阿里MQ短信消费监听器
 * @author Arei
 */
@Component
@RefreshScope
public class SmsMessageListener implements MessageListener {
    private static final Logger logger = LoggerFactory.getLogger(SmsMessageListener.class);

    @Resource
    private SmsOperatorConfig smsOperatorConfig;

    @Resource
    private MessageProperties messageProperties;

    @Override
    public Action consume(Message message, ConsumeContext consumeContext) {
        if (!messageProperties.getEnableSms()) {
            logger.debug("短信未开启");
            logger.debug(new String(message.getBody()));
            return Action.CommitMessage;
        }

        try {
            String msg = new String(message.getBody());
            JSONObject smsJson = JSONObject.parseObject(msg);

            if ("shiyuan".equals(smsOperatorConfig.getOperator())) {
                String[] result = SmsFactory.send(AppConst.Sms.SHIYUAN, smsJson.getString("phoneNo"), smsJson.getString("content"));
                if (!result[0].equals("1")) {

                    logger.error("短信消费失败:" + result[0] + ":" + result[1], smsJson.getString("phoneNo") + ":" + smsJson.getString("content"));

                    //消费失败
                    return Action.ReconsumeLater;
                } else {
                    logger.debug("短信消费成功", result[0] + "," + result[1]);
                }
            }

            if ("chuanglan".equals(smsOperatorConfig.getOperator())) {
                String[] result = SmsFactory.send(AppConst.Sms.CHUANGLAN, smsJson.getString("phoneNo"), smsJson.getString("content"));
                if (!result[0].equals("0")) {

                    logger.error("短信消费失败:" + result[0] + ":" + result[1], smsJson.getString("phoneNo") + ":" + smsJson.getString("content"));

                    //消费失败
                    return Action.ReconsumeLater;
                } else {
                    logger.debug("短信消费成功", result[0] + "," + result[1]);
                }
            }
            return Action.CommitMessage;
        } catch (Exception e) {
            //消费失败
            logger.error("短信消费失败:" + e.getMessage(), e);
            return Action.ReconsumeLater;
        }

    }


}
