package com.bxm.localnews.msg.produce;

import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.SendResult;
import com.bxm.localnews.mq.common.constant.AliMqMsgTagEnum;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

/**
 * 阿里云消息队列服务
 * @author liujia 2018/8/11 18:25
 */
public interface AliMqService extends ApplicationListener<ContextRefreshedEvent>, ApplicationContextAware {

    /**
     * 构建一个消息对象
     * @param tag  详细取值见{@link MQConstant.TAG}
     * @param data 消息对象主体内容
     * @return 消息对象，可附加额外用户自定义内容
     */
    <T> Message createMessage(String tag, T data);

    /**
     * 发送消息
     * @param message 消息主体
     * @return 发送结果
     */
    SendResult send(Message message);

    <T> Message createMessage(AliMqMsgTagEnum tagEnum, T data);
}
