package com.bxm.localnews.msg.produce;

/**
 * Created by Arei on 2018/10/11.
 * 对外提供新闻数据服务
 * @author Arei
 */
public interface NewsStatisticService {

    /**
     * 推送分享新闻数据信息
     * @param newsId
     * @param userId
     */
    void pushShareData(Long newsId, Long userId);

    /**
     * 推送阅读新闻数据信息，active_view为有效阅读，暂定义：每个用户对于一个新闻只能有一次有效阅读次数
     * 保存在news_record表中
     * @param newsId
     * @param userId
     */
    void pushViewData(Long newsId, Long userId);

    /**
     * 推送推荐新闻数据
     * @param newsIds 推荐的新闻列表id
     * @param userId
     */
    void pushRecommededData(String newsIds, Long userId);

    /**
     * 推送点击新闻数据，意义上与view差不多，暂时没有明确定义
     * @param newsId
     * @param userId
     */
    void pushNewClickData(Long newsId, Long userId);

    /**
     * 推送收藏新闻数据
     * @param newsId
     * @param userId
     * @param type   0:取消收藏 1:收藏
     */
    void pushCollectData(Long newsId, Long userId, Byte type);

    /**
     * 推送评论新闻数据
     * @param newsId
     * @param userId
     */
    void pushCommentData(Long newsId, Long userId);

}
