package com.bxm.localnews.msg.push.platform;

import com.bxm.localnews.mq.common.constant.PlatformTypeEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.msg.vo.UserDeviceBean;

import java.util.List;

/**
 * 消息推送平台接口
 */
public interface IPushPlatform {

    /**
     * 执行消息推送
     * @param message    推送的消息实体
     * @param userDevice 用户设备信息
     */
    void push(PushMessage message, List<UserDeviceBean> userDevice);

    /**
     * 推送平台类型
     * @return 平台枚举
     */
    PlatformTypeEnum getType();
}
