package com.bxm.localnews.msg.push.receive;

import com.bxm.localnews.mq.common.constant.PlatformTypeEnum;
import com.bxm.localnews.msg.domain.UserDeviceMapper;
import com.bxm.localnews.msg.vo.UserDeviceBean;

import java.util.Iterator;
import java.util.List;
import java.util.Map;

/**
 * 接收用户列表迭代器
 */
public interface IReceiveUserIterator extends Iterator<Map<PlatformTypeEnum, List<UserDeviceBean>>> {

    /**
     * 构建用户信息获取迭代器
     * @param paramMap 构建参数
     * @return 迭代器对象
     */
    IReceiveUserIterator build(Map<String, Object> paramMap);

    IReceiveUserIterator setUserDeviceMapper(UserDeviceMapper userDeviceMapper);
}
