package com.bxm.localnews.msg.push.receive;

import com.bxm.localnews.mq.common.constant.PushReceiverRuleEnum;
import com.bxm.localnews.msg.domain.UserDeviceMapper;
import com.bxm.localnews.msg.push.receive.impl.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * 构建用户获取迭代器对象
 */
@Component
public class ReceiveUserFactory {

    private final UserDeviceMapper userDeviceMapper;

    private ApplicationContext applicationContext;

    private Map<PushReceiverRuleEnum, IReceiveUserIterator> iteratorMap;

    @Autowired
    public ReceiveUserFactory(UserDeviceMapper userDeviceMapper) {
        this.userDeviceMapper = userDeviceMapper;
    }

    public IReceiveUserIterator get(PushReceiverRuleEnum rule, Map<String, Object> paramMap) {
        IReceiveUserIterator iterator;
        switch (rule) {
            case AREA:
                iterator = new AreaReceiveUserIterator();
                break;
            case ALL:
                iterator = new AllReceiveUserIterator();
                break;
            case VIP_AREA:
                iterator = new AreaVipReceiveUserIterator();
                break;
            case VIP_USER:
                iterator = new UserVipReceiveUserIterator();
                break;
            default:
                iterator = new DefaultUserReceiveUserIterator();
        }
        return iterator.build(paramMap).setUserDeviceMapper(userDeviceMapper);
    }
}
