package com.bxm.localnews.msg.push.receive.impl;

import com.bxm.localnews.mq.common.constant.ReceiverRuleParamConstant;
import com.bxm.localnews.msg.push.receive.IReceiveUserIterator;
import com.bxm.localnews.msg.vo.UserDeviceBean;

import java.util.List;
import java.util.Map;

/**
 * 默认的用户信息迭代器，当传入批量的用户ID和单个用户时，由此迭代器进行处理
 */
public class DefaultUserReceiveUserIterator extends AbstractReceiveUserIterator {

    private List<Long> userIds;

    @Override
    int getTotal() {
        userIds = getParam(ReceiverRuleParamConstant.USER_IDS);
        return userIds.size();
    }

    @Override
    List<UserDeviceBean> queryByPage(int pageNum) {
        int lastSize = (pageNum + 1) * pageSize;
        if (userIds.size() < lastSize) {
            lastSize = userIds.size();
        }
        return userDeviceMapper.queryUserList(userIds.subList(pageNum * pageSize, lastSize));
    }

    @Override
    public IReceiveUserIterator build(Map<String, Object> paramMap) {
        DefaultUserReceiveUserIterator iterator = new DefaultUserReceiveUserIterator();
        iterator.paramMap = paramMap;
        return iterator;
    }
}
