package com.bxm.localnews.msg.service;


import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.msg.dto.MessageTypeDTO;
import com.bxm.localnews.msg.param.MessageListParam;
import com.bxm.localnews.msg.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;

/**
 * Created by Administrator on 2018/2/9 0009.
 */
public interface MessageService {


    /**
     * 获取未读的消息总数，不同平台的消息处理有区别
     * @param userId   用户ID
     * @param platform 请求平台
     * @return 用户未读消息总数
     */
    int getUnReadMsg(Long userId, Integer platform);

    /**
     * 分页获取用户某个类目下的消息列表
     * @param param      查询参数
     * @param basicParam 基础参数
     * @return 分页消息数据
     */
    PageWarper<Message> listMessage(MessageListParam param, BasicParam basicParam);

    /**
     * 获取用户消息中心列表，包括广告信息
     * @param areaCode   地区编码
     * @param userId     用户ID
     * @param basicParam 基础参数
     * @return 用户消息中心列表
     */
    MessageTypeDTO getMessageType(String areaCode, Long userId, BasicParam basicParam);

    /**
     * 添加用户的未读消息
     * 1.记录用户的不同类型最后未读消息总数
     * 2.记录用户不同类型的最后一条未读消息信息
     * 3.尝试给用户推送小程序模板消息
     * @param message 消息内容
     * @param userId  目标用户ID
     */
    void addUnreadMsg(PushMessage message, Long userId);

    /**
     * 给用户设置最后的未读消息
     * @param message 消息内容
     */
    void addLastMsg(PushMessage message);

    /**
     * 将某个类目下的消息设置为已读，并清空相关缓存
     * @param userId      用户ID
     * @param messageType 消息类目
     */
    void updateMessageByType(Long userId, String messageType);

    /**
     * 添加消息
     * @param message 待添加到消息中心的消息
     * @param userId  用户ID
     */
    void addMessage(PushMessage message, Long userId);
}
