package com.bxm.localnews.msg.service.impl;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.msg.domain.MessageMapper;
import com.bxm.localnews.msg.domain.MessageUserMapper;
import com.bxm.localnews.msg.service.MessageService;
import com.bxm.localnews.msg.service.MessageUserService;
import com.bxm.localnews.msg.vo.Message;
import com.bxm.localnews.msg.vo.MessageUser;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

/**
 * Created by Administrator on 2018/2/9 0009.
 */
@Service
@Transactional(rollbackFor = Exception.class)
public class MessageUserServiceImpl implements MessageUserService {

    private final transient MessageUserMapper messageUserMapper;

    private final transient MessageMapper messageMapper;

    private final MessageService messageService;

    private final RedisStringAdapter redisStringAdapter;

    @Autowired
    public MessageUserServiceImpl(MessageUserMapper messageUserMapper,
                                  MessageMapper messageMapper,
                                  MessageService messageService,
                                  RedisStringAdapter redisStringAdapter) {
        this.messageUserMapper = messageUserMapper;
        this.messageMapper = messageMapper;
        this.messageService = messageService;
        this.redisStringAdapter = redisStringAdapter;
    }

    @Override
    public Json updateOrDelete(Integer id, Byte status, Long userId, String messageType) {
        if (id != null) {
            Message message = this.messageMapper.selectByPrimaryKey(id, userId);
            if (message.getUserId() == 0) {
                //公共消息
                this.saveUpdateCommonMsg(id, status, userId);
            } else {
                this.messageMapper.updateMsg(id, status, userId);
            }
        }

        //清除对应类型的已读消息
        messageService.updateMessageByType(userId, messageType);

        return ResultUtil.genSuccessResult();
    }

    @Override
    public Json updateById(Long userId) {
        Message message = new Message(userId, (byte) 2);
        this.messageMapper.updateByUserId(message);
        return ResultUtil.genSuccessResult();
    }

    @Override
    public int countTotalMsg(Long userId) {
        return messageMapper.countMessage(userId);
    }

    private void saveUpdateCommonMsg(Integer id, Byte status, Long userId) {
        MessageUser messageUser = this.messageUserMapper.selectByMsgId(id, userId);
        if (ObjectUtils.isEmpty(messageUser)) {
            MessageUser insertMsg = new MessageUser(userId, id, status);
            this.messageUserMapper.insertSelective(insertMsg);
        } else {
            messageUser.setStatus(status);
            this.messageUserMapper.updateByPrimaryKeySelective(messageUser);
        }
    }

}
