package com.bxm.localnews.msg.utils;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.localnews.msg.common.RedisConfig;
import com.bxm.localnews.msg.domain.PushUserMapper;
import com.bxm.localnews.msg.dto.UserInfoDTO;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.tools.StringUtils;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

@Component
public class PlaceHolderUtils {
    private static final String USER_NICKNAME = "{nickname}";

    @Resource
    private RedisHashMapAdapter redisHashMapAdapter;

    @Resource
    private PushUserMapper pushUserMapper;

    public boolean havePlaceholder(PushMessage message) {
        if (message.getContent() != null && message.getContent().contains(USER_NICKNAME)) {
            return true;
        } else if (message.getPayloadInfo() != null && message.getPayloadInfo().getContent() != null) {
            return message.getPayloadInfo().getContent().contains(USER_NICKNAME);
        }

        return false;
    }

    public void processPlaceholders(PushMessage message, Long userId, boolean havePlaceholder) {
        if (!havePlaceholder) {
            return;
        }

        String nickname = getUserNicknameFromRedis(userId);
        if (null == nickname) {
            nickname = "";
        }

        if (message.getContent() != null) {
            message.setContent(message.getContent().replace(USER_NICKNAME, nickname));
        }

        PushPayloadInfo pushPayloadInfo = message.getPayloadInfo();
        if (null != pushPayloadInfo && null != pushPayloadInfo.getContent()) {
            pushPayloadInfo.setContent(pushPayloadInfo.getContent().replace(USER_NICKNAME, nickname));
            message.setPayloadInfo(pushPayloadInfo);
        }
    }

    private String getUserNicknameFromRedis(Long userId) {
        String userStr = this.redisHashMapAdapter.get(RedisConfig.USER_INFO, userId + "", String.class);
        UserInfoDTO dto = JSON.parseObject(userStr, UserInfoDTO.class);

        if (null == dto || StringUtils.isEmpty(dto.getNickname())) {
            return this.pushUserMapper.selectNicknameByUserId(userId);
        }

        return dto.getNickname();
    }

}
