package com.bxm.localnews.mq.common;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.impl.DefaultKeyGenerator;

/**
 * redis 缓存的key值，格式为： {业务类型：模块：子模块:更下级模块}
 * 业务类型： biz:业务  config:配置
 */
public class RedisConfig {

    /**
     * ============================= message模块 ==============================
     */
    /**
     * 短信相关RedisKey模版
     */
    public static KeyGenerator MESSAGE_SMS = DefaultKeyGenerator.build("message", "sms");

    /**
     * 互动消息（未读消息条数）
     */
    public static KeyGenerator INTERACTION_MSG = DefaultKeyGenerator.build("message", "interaction");

    /**
     * 系统通知（未读消息条数）
     */
    public static KeyGenerator SYSTEM_MSG = DefaultKeyGenerator.build("message", "system");

    /**
     * 今日热闻（未读消息条数）
     */
    public static KeyGenerator NEWS_MSG = DefaultKeyGenerator.build("message", "news");

    /**
     * 余额变动（未读消息条数）
     */
    public static KeyGenerator BALANCE_MSG = DefaultKeyGenerator.build("message", "balance");

    /**
     * 评论变动（未读消息条数）
     */
    public static KeyGenerator COMMENT_MSG = DefaultKeyGenerator.build("message", "comment");

    /**
     * 点赞变动（未读消息条数）
     */
    public static KeyGenerator LIKE_MSG = DefaultKeyGenerator.build("message", "like");

    /**
     * 分享变动（未读消息条数）
     */
    public static KeyGenerator SHARE_MSG = DefaultKeyGenerator.build("message", "share");

    /**
     * 邀请变动（未读消息条数）
     */
    public static KeyGenerator INVITE_MSG = DefaultKeyGenerator.build("message", "invite");

    /**
     * 任务变动（未读消息条数）
     */
    public static KeyGenerator TASK_MSG = DefaultKeyGenerator.build("message", "task");

    /**
     * 默认消息未读条数
     */
    public static KeyGenerator DEFAULT_MSG = DefaultKeyGenerator.build("message", "default");

    /**
     * ======================== user模块 事件 ==========================
     */

    /**
     * 用户的缓存通知事件
     */
    public static KeyGenerator USER_EVENTS = DefaultKeyGenerator.build("user", "cache", "events");

    /**
     * 有未消费事件的用户ID
     */
    public static KeyGenerator HAS_EVENT_SET = DefaultKeyGenerator.build("user", "cache", "hasevent");
}
