package com.bxm.localnews.mq.config;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import com.bxm.newidea.component.tools.StringUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * @author zhaoyadong 2019/4/8 13:56
 * @desc
 */
@Component
@ConfigurationProperties("message.config.message")
public class MessageTypeProperties {

    /**
     * 消息类型标题
     */
    private List<String> typeTitle = Lists.newArrayList();

    /**
     * 消息类型列表
     */
    private List<String> typeName = Lists.newArrayList();

    /**
     * 消息图标列表
     */
    private List<String> typeImg = Lists.newArrayList();

    private Map<String, String> type = Maps.newHashMap();

    private Map<String, List<String>> msgTypeMap = Maps.newHashMap();

    /**
     * 模板消息推送的类型列表
     */
    private String template;

    /**
     * 转换类型
     */
    private List<Integer> templateList = Lists.newArrayList();

    /**
     * 互动消息类型
     */
    private List<String> interactionList = Lists.newArrayList();

    public List<String> getTypeTitle() {
        return typeTitle;
    }

    public void setTypeTitle(List<String> typeTitle) {
        this.typeTitle = typeTitle;
    }

    public List<String> getTypeName() {
        return typeName;
    }

    public void setTypeName(List<String> typeName) {
        this.typeName = typeName;
    }

    public List<String> getTypeImg() {
        return typeImg;
    }

    public void setTypeImg(List<String> typeImg) {
        this.typeImg = typeImg;
    }

    public Map<String, String> getType() {
        return type;
    }

    public void setType(Map<String, String> type) {
        this.type = type;
        Iterator<Map.Entry<String, String>> iterator = type.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            msgTypeMap.put(entry.getKey(), Stream.of(StringUtils.split(entry.getValue(), ","))
                    .collect(Collectors.toList()));
        }
    }

    public Map<String, List<String>> getMsgTypeMap() {
        return msgTypeMap;
    }

    public String getTemplate() {
        return template;
    }

    public void setTemplate(String template) {
        this.template = template;
        templateList = Stream.of(StringUtils.split(template, ",")).map(Integer::new).collect(Collectors.toList());
    }

    public List<Integer> getTemplateList() {
        return templateList;
    }

    public void setTemplateList(List<Integer> templateList) {
        this.templateList = templateList;
    }

    public List<String> getInteractionList() {
        return interactionList;
    }

    public void setInteractionList(List<String> interactionList) {
        this.interactionList = interactionList;
    }
}
