package com.bxm.localnews.mq.consume.consumer;

import com.aliyun.openservices.ons.api.Action;
import com.aliyun.openservices.ons.api.ConsumeContext;
import com.aliyun.openservices.ons.api.Message;

/**
 * 带有标签的消息消费者,暂时只有一个队列可用，故此根据标签进行消息消费
 * @author liujia 2018/8/11 23:20
 */
public interface NewsActionMessageConsumer {

    /**
     * 是否支持对指定消息类型进行消费
     * @param tag
     * @return
     */
    boolean support(String tag);

    /**
     * 优先级，降序排列
     * @return
     */
    default int order() {
        return 0;
    }

    /**
     * 进行消息消费
     * @param message 消息主体
     * @param context 消费者上下文
     * @return 消费结果，如果未消费会继续往下传递，知道反馈回消息队列
     */
    Action consume(Message message, ConsumeContext context);

}

