package com.bxm.localnews.mq.consume.integration.fallback;

import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.mq.consume.integration.NewsSyncFeignService;
import com.bxm.localnews.mq.consume.param.NewsRecommended;
import com.bxm.localnews.mq.consume.param.NewsStatistics;
import feign.hystrix.FallbackFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
public class NewsSyncFallbackFactory implements FallbackFactory<NewsSyncFeignService> {

    private static final Logger LOGGER = LoggerFactory.getLogger(NewsSyncFallbackFactory.class);

    @Override
    public NewsSyncFeignService create(Throwable throwable) {
        return new NewsSyncFeignService() {
            @Override
            public ResponseEntity updateStatistic(List<NewsStatistics> newsStatisticsList) {
                //记录请求参数
                LOGGER.error("newsStatisticsList,参数:{}", JSONObject.toJSONString(newsStatisticsList));
                //记录错误消息
                LOGGER.error(throwable.getMessage(), throwable);
                return null;
            }

            @Override
            public ResponseEntity saveRecommended(List<NewsRecommended> newsRecommendedList) {
                LOGGER.error("newsRecommendedList,参数:{}", JSONObject.toJSONString(newsRecommendedList));
                LOGGER.error(throwable.getMessage(), throwable);
                return null;
            }

        };
    }
}