package com.bxm.localnews.mq.consume.service.impl;

import javax.annotation.Resource;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.mq.consume.service.MessageService;
import com.bxm.localnews.mq.consume.service.MessageUserService;
import com.bxm.localnews.msg.domain.MessageMapper;
import com.bxm.localnews.msg.domain.MessageUserMapper;
import com.bxm.localnews.msg.vo.Message;
import com.bxm.localnews.msg.vo.MessageUser;
import com.bxm.newidea.component.redis.RedisStringAdapter;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

/**
 * Created by Administrator on 2018/2/9 0009.
 */
@Service
@Transactional(rollbackFor = Exception.class)
public class MessageUserServiceImpl implements MessageUserService {

    @Resource
    private transient MessageUserMapper messageUserMapper;

    @Resource
    private transient MessageMapper messageMapper;

    @Autowired
    private MessageService messageService;

    @Autowired
    private RedisStringAdapter redisStringAdapter;

    @Override
    public Json updateById(Long userId) {
        Message message = new Message(userId, (byte) 2);
        this.messageMapper.updateByUserId(message);
        return ResultUtil.genSuccessResult();
    }

    @Override
    public Json updateOrDelete(Integer id, Byte status, Long userId, String messageType) {
        Boolean isUpdate = false;
        if (id != null) {
            Message message = this.messageMapper.selectByPrimaryKey(id);
            if (message.getUserId() == 0) {
                //公共消息
                this.saveUpdateCommonMsg(id, status, userId);
            } else {
                isUpdate = this.updateMsg(id, status, userId);
            }
        }

        //清除对应类型的已读消息
        if ("INTERACTION".equals(messageType) && isUpdate) {
            redisStringAdapter.decrement(messageService.getMsgKeyByType(messageType, userId));
        } else {
            redisStringAdapter.remove(messageService.getMsgKeyByType(messageType, userId));
            messageService.updateMessageByType(userId, messageType);
        }

        return ResultUtil.genSuccessResult();
    }

    @Override
    public int countTotalMsg(Long userId) {
        return messageMapper.countMessage(userId);
    }

    private Boolean updateMsg(Integer id, Byte status, Long userId) {
        return this.messageMapper.updateMsg(id, status, userId) > 0;
    }

    private void saveUpdateCommonMsg(Integer id, Byte status, Long userId) {
        MessageUser messageUser = this.messageUserMapper.selectByMsgId(id, userId);
        if (ObjectUtils.isEmpty(messageUser)) {
            MessageUser insertMsg = new MessageUser(userId, id, status);
            this.messageUserMapper.insertSelective(insertMsg);
        } else {
            messageUser.setStatus(status);
            this.messageUserMapper.updateByPrimaryKeySelective(messageUser);
        }
    }

}
