package com.bxm.localnews.mq.dingtalk.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.component.httpclient.service.HttpClientService;
import com.bxm.localnews.mq.config.DingtalkProperties;
import com.bxm.localnews.mq.dingtalk.service.DingtalkPushService;
import com.bxm.newidea.component.service.BaseService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;

@Service
@RefreshScope
public class DingtalkPushServiceImpl extends BaseService implements DingtalkPushService {

    @Autowired
    private DingtalkProperties dingtalkProperties;

    @Autowired
    private HttpClientService httpClientService;

    @Override
    public void pushNews(String content) {
        JSONObject text = new JSONObject();
        text.put("content", content);

        JSONObject msg = new JSONObject();
        msg.put("msgtype", "text");
        msg.put("text", text);

        String response = httpClientService.doPostJson(dingtalkProperties.getNewsGroupWebhook(), msg.toJSONString());
        logger.debug("push content:[{}],response:[{}]", content, response);
    }
}
