package com.bxm.localnews.mq.event.service.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.localnews.mq.event.service.UserEventService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.service.BaseService;

import lombok.extern.slf4j.Slf4j;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

import static com.bxm.localnews.mq.common.RedisConfig.HAS_EVENT_SET;
import static com.bxm.localnews.mq.common.RedisConfig.USER_EVENTS;

@Service
@Slf4j
public class UserEventServiceImpl extends BaseService implements UserEventService {

    private RedisHashMapAdapter redisHashMapAdapter;

    private RedisSetAdapter redisSetAdapter;

    private StringRedisTemplate redisTemplate;

    public UserEventServiceImpl(RedisHashMapAdapter redisHashMapAdapter,
                                RedisSetAdapter redisSetAdapter,
                                StringRedisTemplate redisTemplate) {
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.redisSetAdapter = redisSetAdapter;
        this.redisTemplate = redisTemplate;
    }

    @Override
    public void add(PushPayloadInfo payloadInfo) {
        log.debug("添加事件：[{}]", JSON.toJSONString(payloadInfo));
        Object userIdObj = payloadInfo.getExtend().get("userId");
        if (null == userIdObj) {
            log.error("注册用户事件必须传递userId在ext字段中");
            return;
        }
        //抹除用户ID
        payloadInfo.getExtend().remove("userId");
        //给与每一个消息唯一ID
        if (null == payloadInfo.getMsgId()) {
            payloadInfo.setMsgId(nextId());
        }

        String userId = userIdObj.toString();
        KeyGenerator key = USER_EVENTS.copy().appendKey(userId);

        //同一种类型只保留最后一条(如后续有需求，针对不同的type可以给与随机的subkey)
        redisHashMapAdapter.put(key, payloadInfo.getType() + "", payloadInfo);
        redisSetAdapter.add(HAS_EVENT_SET, userId);

        //发送通知事件，channel名称需要与网关中的定义一致
        redisTemplate.convertAndSend("user-event", userId);
        log.debug("成功添加用户[{}]的事件信息[{}]", userId, JSON.toJSONString(payloadInfo));
    }
}
