package com.bxm.localnews.mq.produce.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.mq.common.constant.AliMqMsgTagEnum;
import com.bxm.localnews.mq.common.constant.MQConstant;
import com.bxm.localnews.mq.produce.service.AliMqService;
import com.bxm.localnews.mq.produce.service.NewsStatisticService;
import com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Map;

/**
 * Created by Arei on 2018/10/12.
 */
@Service("newsStatisticService")
public class NewsStatisticServiceImpl implements NewsStatisticService {

    private static final Logger logger = LoggerFactory.getLogger(NewsStatisticServiceImpl.class);

    @Resource
    private AliMqService aliMqService;

    @Override
    public void pushShareData(Long newsId, Long userId) {
        Map<String, Object> shareMap = Maps.newHashMap();
        shareMap.put(MQConstant.NEW_CLICK_KEY.NEWS_ID, newsId);
        shareMap.put(MQConstant.NEW_CLICK_KEY.USER_ID, userId);
        logger.debug("分享新闻数据上报,参数:{}", JSONObject.toJSONString(shareMap));
        aliMqService.send(aliMqService.createMessage(AliMqMsgTagEnum.SHARE, shareMap));
    }

    @Override
    public void pushViewData(Long newsId, Long userId) {
        Map<String, Object> viewMap = Maps.newHashMap();
        viewMap.put(MQConstant.NEW_CLICK_KEY.NEWS_ID, newsId);
        viewMap.put(MQConstant.NEW_CLICK_KEY.USER_ID, userId);
        logger.debug("浏览新闻数据上报,参数:{}", JSONObject.toJSONString(viewMap));
        aliMqService.send(aliMqService.createMessage(AliMqMsgTagEnum.VIEW, viewMap));
    }

    @Override
    public void pushRecommededData(String newsIds, Long userId) {
        Map<String, Object> recommededMap = Maps.newHashMap();
        recommededMap.put(MQConstant.NEW_CLICK_KEY.NEWS_ID, newsIds);
        recommededMap.put(MQConstant.NEW_CLICK_KEY.USER_ID, userId);
        logger.debug("推荐新闻数据上报,参数:{}", JSONObject.toJSONString(recommededMap));
        aliMqService.send(aliMqService.createMessage(AliMqMsgTagEnum.RECOMMENDED, recommededMap));
    }

    @Override
    public void pushNewClickData(Long newsId, Long userId) {
        Map<String, Object> newClickMap = Maps.newHashMap();
        newClickMap.put(MQConstant.NEW_CLICK_KEY.NEWS_ID, newsId);
        newClickMap.put(MQConstant.NEW_CLICK_KEY.USER_ID, userId);
        logger.debug("点击新闻数据上报,参数:{}", JSONObject.toJSONString(newClickMap));
        aliMqService.send(aliMqService.createMessage(AliMqMsgTagEnum.NEW_CLICK, newClickMap));
    }

    @Override
    public void pushCollectData(Long newsId, Long userId, Byte type) {
        Map<String, Object> collectMap = Maps.newHashMap();
        collectMap.put(MQConstant.NEW_CLICK_KEY.NEWS_ID, newsId);
        collectMap.put(MQConstant.NEW_CLICK_KEY.USER_ID, userId);
        collectMap.put("type", type);
        logger.debug("收藏新闻数据上报,参数:{}", JSONObject.toJSONString(collectMap));
        aliMqService.send(aliMqService.createMessage(AliMqMsgTagEnum.COLLECT, collectMap));
    }

    @Override
    public void pushCommentData(Long newsId, Long userId) {
        Map<String, Object> commentMap = Maps.newHashMap();
        commentMap.put(MQConstant.NEW_CLICK_KEY.NEWS_ID, newsId);
        commentMap.put(MQConstant.NEW_CLICK_KEY.USER_ID, userId);
        logger.debug("评论新闻数据上报,参数:{}", JSONObject.toJSONString(commentMap));
        aliMqService.send(aliMqService.createMessage(AliMqMsgTagEnum.COMMENT, commentMap));
    }
}
