package com.bxm.localnews.mq.produce.service.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.mq.common.constant.AliMqMsgTagEnum;
import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.mq.common.constant.TemplateTypeEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.localnews.mq.common.model.dto.PushReceiveScope;
import com.bxm.localnews.mq.config.MessageTypeProperties;
import com.bxm.localnews.mq.consume.service.MessageService;
import com.bxm.localnews.mq.produce.service.AliMqService;
import com.bxm.localnews.mq.produce.service.PushMsgSupplyService;
import com.bxm.localnews.msg.vo.Message;
import com.bxm.newidea.component.service.BaseService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * Created by Arei on 2018/10/12.
 */
@Service("pushMsgSupplyService")
public class PushMsgSupplyServiceImpl extends BaseService implements PushMsgSupplyService {
    private static final Logger logger = LoggerFactory.getLogger(PushMsgSupplyServiceImpl.class);

    @Resource
    private AliMqService aliMqService;

    @Resource
    private MessageService messageService;

    @Resource
    private MessageTypeProperties messageTypeProperties;

    @Override
    public void pushMsg(PushMessage message) {
        aliMqService.send(aliMqService.createMessage(AliMqMsgTagEnum.PUSH, message));
        messageService.pushTemplateMessage(message);
    }

    @Override
    public void pushInteraction() {
        logger.debug("---------- 互动消息未读推送开始 ------------");
        //TODO [liujia]避免从数据库查询互动消息

        List<String> msgTypeList = messageTypeProperties.getInteractionList();
        List<Message> messageList = messageService.getMessageListByType(msgTypeList);
        if (CollectionUtils.isEmpty(messageList)) {
            logger.debug("互动消息推送列表为空");
            return;
        }

        Map<Long, List<Message>> userMessageList = messageList.stream().collect(Collectors.groupingBy(Message::getUserId));
        userMessageList.forEach((userId, messages) -> {
            PushMessage pushMessage = PushMessage.build();

            Long msgId = nextId();
            if (messages.size() == 1) {
                pushMessage.setPersistence(false);
                Message message = messages.get(0);
                PushPayloadInfo payloadInfo = JSON.parseObject(message.getLinkParam(), PushPayloadInfo.class);
                pushMessage.setTitle(message.getTitle());
                pushMessage.setContent(message.getContent());
                pushMessage.setType(TemplateTypeEnum.NOTIFCTION);
                pushMessage.setPushReceiveScope(PushReceiveScope.pushSignle(userId));
                pushMessage.setPayloadInfo(payloadInfo);
            } else {
                //2.5.0 合并推送不显示在消息中心
                pushMessage.setPersistence(false);
                Message message = messages.get(messages.size() - 1);
                PushPayloadInfo payloadInfo = JSON.parseObject(message.getLinkParam(), PushPayloadInfo.class);
                String name = payloadInfo.getExtend().get("nickname").toString();
                String title = name + " 等用户跟你有" + messages.size() + "条互动消息哦，快来看看吧";

                PushPayloadInfo info = PushPayloadInfo.build(PushMessageEnum.INTERACTION_MSG);
                info.setMsgId(msgId);
                info.addExtend("msgId", msgId);

                pushMessage.setTitle("");
                pushMessage.setContent(title);
                pushMessage.setType(TemplateTypeEnum.NOTIFCTION);
                pushMessage.setPushReceiveScope(PushReceiveScope.pushSignle(userId));
                pushMessage.setPayloadInfo(info);
            }
            pushMsg(pushMessage);
        });
        logger.debug("---------- 互动消息未读推送结束 ------------");
    }
}
