/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.msg.event.impl;

import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.localnews.msg.constant.RedisConfig;
import com.bxm.localnews.msg.event.UserEventService;
import com.bxm.localnews.msg.stream.MessageProvider;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.service.BaseService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UserEventServiceImpl
extends BaseService
implements UserEventService {
    private static final Logger log = LoggerFactory.getLogger(UserEventServiceImpl.class);
    private RedisHashMapAdapter redisHashMapAdapter;
    private RedisSetAdapter redisSetAdapter;
    private final MessageProvider messageProvider;
    private static final long USER_EVENT_EXPIRED_MILLS = 604800L;

    public UserEventServiceImpl(RedisHashMapAdapter redisHashMapAdapter, RedisSetAdapter redisSetAdapter, MessageProvider messageProvider) {
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.redisSetAdapter = redisSetAdapter;
        this.messageProvider = messageProvider;
    }

    @Override
    public void add(PushPayloadInfo payloadInfo) {
        Long userId = payloadInfo.getTargetUserId();
        if (null == userId) {
            log.error("\u6ce8\u518c\u7528\u6237\u4e8b\u4ef6\u5fc5\u987b\u4f20\u9012userId\u5728ext\u5b57\u6bb5\u4e2d");
            return;
        }
        payloadInfo.getExtend().remove("userId");
        if (null == payloadInfo.getMsgId()) {
            payloadInfo.setMsgId(Long.valueOf(this.nextId()));
        }
        KeyGenerator key = RedisConfig.USER_EVENTS.copy().appendKey((Object)userId);
        KeyGenerator hasEventUserKey = RedisConfig.HAS_EVENT_SET.copy().appendKey((Object)(userId % 64L));
        this.redisHashMapAdapter.put(key, String.valueOf(payloadInfo.getType()), (Object)payloadInfo);
        this.redisHashMapAdapter.expire(key, 604800L);
        this.redisSetAdapter.add(hasEventUserKey, new Object[]{userId.toString()});
        this.messageProvider.userEvent(userId);
    }
}

