/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.msg.service.filter.process.filter;

import com.bxm.localnews.mq.common.constant.MessageFilterEventTypeEnum;
import com.bxm.localnews.msg.config.MessageTypeProperties;
import com.bxm.localnews.msg.constant.RedisConfig;
import com.bxm.localnews.msg.service.filter.MessageFilterStrategy;
import com.bxm.localnews.msg.vo.UserMessageBean;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ReplyFilterStrategy
implements MessageFilterStrategy {
    @Resource
    private RedisHashMapAdapter redisHashMapAdapter;
    @Resource
    private MessageTypeProperties messageTypeProperties;

    @Override
    public Object filter(Object param, String msgType) {
        UserMessageBean result = null;
        if (param instanceof UserMessageBean && Objects.nonNull((result = (UserMessageBean)param).getReplyId()) && this.messageTypeProperties.isInteraction(msgType) && this.checkReply(result.getReplyId())) {
            result.setStatus(Byte.valueOf((byte)2));
            result.setReadStatus(result.getStatus());
            result.setContent("\u8be5\u8bc4\u8bba\u5df2\u5220\u9664\uff01");
        }
        return result;
    }

    @Override
    public boolean match(MessageFilterEventTypeEnum messageFilterType) {
        return Objects.equals(messageFilterType, MessageFilterEventTypeEnum.COMMENT_REPLY_DELETE_EVENT);
    }

    private boolean checkReply(Long replyId) {
        TypeReference<List<Long>> typeReference = new TypeReference<List<Long>>(){};
        List replyIds = (List)this.redisHashMapAdapter.get(RedisConfig.MESSAGE_FILTER_CONTENT_KEY.copy(), MessageFilterEventTypeEnum.COMMENT_REPLY_DELETE_EVENT.name().toLowerCase(), (TypeReference)typeReference);
        if (CollectionUtils.isEmpty((Collection)replyIds)) {
            return false;
        }
        return replyIds.contains(replyId);
    }
}

