/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.msg.service.filter.process.save;

import com.bxm.localnews.mq.common.constant.MessageFilterEventTypeEnum;
import com.bxm.localnews.mq.common.model.dto.MessageFilterInfo;
import com.bxm.localnews.msg.constant.RedisConfig;
import com.bxm.localnews.msg.service.filter.MessageFilterSaveStrategy;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ReplyFilterSaveStrategy
implements MessageFilterSaveStrategy {
    @Resource
    private RedisHashMapAdapter redisHashMapAdapter;

    @Override
    public void saveLogic(MessageFilterInfo info) {
        if (Objects.equals(info.getEventTypeEnum(), MessageFilterEventTypeEnum.COMMENT_REPLY_DELETE_EVENT)) {
            TypeReference<List<Long>> typeReference = new TypeReference<List<Long>>(){};
            List replyIds = (List)this.redisHashMapAdapter.get(this.key(), info.getEventTypeEnum().name().toLowerCase(), (TypeReference)typeReference);
            if (CollectionUtils.isEmpty((Collection)replyIds)) {
                this.redisHashMapAdapter.put(this.key(), info.getEventTypeEnum().name().toLowerCase(), (Object)Lists.newArrayList((Object[])new Long[]{info.getLogicId()}));
            } else {
                replyIds.add(info.getLogicId());
                this.redisHashMapAdapter.put(this.key(), info.getEventTypeEnum().name().toLowerCase(), (Object)replyIds);
            }
        }
    }

    @Override
    public boolean match(MessageFilterInfo info) {
        return Objects.equals(info.getEventTypeEnum(), MessageFilterEventTypeEnum.COMMENT_REPLY_DELETE_EVENT);
    }

    private KeyGenerator key() {
        return RedisConfig.MESSAGE_FILTER_CONTENT_KEY.copy();
    }
}

