/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.msg.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.common.constant.PlatformEnum;
import com.bxm.localnews.common.util.DateFormatUtils;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.mq.common.constant.MessageBehaviorEnum;
import com.bxm.localnews.mq.common.constant.MessageFilterEventTypeEnum;
import com.bxm.localnews.mq.common.constant.MessageTypeEnum;
import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.mq.common.constant.PushReceiverRuleEnum;
import com.bxm.localnews.mq.common.constant.UserEventEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.localnews.mq.common.model.dto.PushReceiveScope;
import com.bxm.localnews.msg.config.InteractMessageProperties;
import com.bxm.localnews.msg.config.MessageTypeProperties;
import com.bxm.localnews.msg.constant.RedisConfig;
import com.bxm.localnews.msg.domain.MessageMapper;
import com.bxm.localnews.msg.dto.InteractMessageDTO;
import com.bxm.localnews.msg.dto.MessageType;
import com.bxm.localnews.msg.dto.MessageTypeDTO;
import com.bxm.localnews.msg.dto.MessageTypeNewDTO;
import com.bxm.localnews.msg.event.UserEventService;
import com.bxm.localnews.msg.integration.AdvertIntegrationService;
import com.bxm.localnews.msg.integration.AppVersionIntegrationService;
import com.bxm.localnews.msg.integration.PushTemplateMessageIntegrationService;
import com.bxm.localnews.msg.param.MessageListParam;
import com.bxm.localnews.msg.param.MsgCenterNewParam;
import com.bxm.localnews.msg.service.UserMessageService;
import com.bxm.localnews.msg.service.filter.MessageFilterStrategyManage;
import com.bxm.localnews.msg.utils.IntervalPeriodUtils;
import com.bxm.localnews.msg.vo.Tuple;
import com.bxm.localnews.msg.vo.UserMessageBean;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.PageWarper;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.joda.time.DateTimeComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@Transactional(rollbackFor={Exception.class})
@RefreshScope
public class UserMessageServiceImpl
implements UserMessageService {
    private static final Logger log = LoggerFactory.getLogger(UserMessageServiceImpl.class);
    private static final String NICKNAME = "nickname";
    private static final String EXTEND = "extend";
    private static final String ACTION = "action";
    private static final String ICON = "icon";
    private static final String EXTEND_CONTENT = "extendContent";
    private static final String EXTEND_URL = "extendUrl";
    private static final String HEAD_IMG = "headImg";
    private static final String CUSTOM_TYPE = "customType";
    private static final String REPLY_ID = "replyId";
    @Resource
    private MessageMapper messageMapper;
    @Resource
    private RedisHashMapAdapter redisHashMapAdapter;
    @Resource
    private AdvertIntegrationService advertIntegrationService;
    @Resource
    private MessageTypeProperties messageTypeProperties;
    @Resource
    private AppVersionIntegrationService appVersionIntegrationService;
    @Resource
    private UserEventService userEventService;
    private DateTimeComparator dateTimeComparator = DateTimeComparator.getInstance();
    @Resource
    private PushTemplateMessageIntegrationService pushTemplateMessageIntegrationService;
    @Resource
    private SequenceCreater sequenceCreater;
    @Resource
    private InteractMessageProperties interactMessageProperties;
    @Resource
    private MessageFilterStrategyManage messageFilterStrategyManage;

    @Override
    public int getUnReadMsg(Long userId, Integer platform, String curVer) {
        Map<String, Long> unreadNumMap = this.getUnreadMsgNumMap(userId);
        if (platform.intValue() == PlatformEnum.APPLET.getCode()) {
            unreadNumMap.remove(MessageTypeEnum.BALANCE.name());
        } else {
            unreadNumMap.remove(MessageTypeEnum.INVITE.name());
        }
        Long unread = unreadNumMap.values().stream().mapToLong(v -> v).sum();
        if (log.isDebugEnabled()) {
            log.debug("{}\u5728\u5e73\u53f0{},\u5ba2\u6237\u7aef\u7248\u672c\uff1a{},\u672a\u8bfb\u6d88\u606f\u603b\u6570\u4e3a\uff1a{}", new Object[]{userId, platform, curVer, unread});
        }
        return unread.intValue();
    }

    @Override
    public PageWarper<UserMessageBean> listMessage(MessageListParam messageListParam, BasicParam basicParam) {
        if (MessageTypeEnum.INTERACTION.name().equals(messageListParam.getMessageType())) {
            return new PageWarper((List)Lists.newArrayList());
        }
        this.constructionParam(messageListParam);
        if (CollectionUtils.isEmpty((Collection)messageListParam.getMsgTypeList())) {
            return new PageWarper((List)Lists.newArrayList());
        }
        if (log.isDebugEnabled()) {
            log.debug("\u7528\u6237\u6d88\u606f\u5217\u8868\uff0c\u67e5\u8be2\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)messageListParam));
        }
        PageWarper msgPage = new PageWarper(this.messageMapper.listMessage(messageListParam));
        String messageType = messageListParam.getMessageType();
        msgPage.getList().forEach(message -> {
            MessageBehaviorEnum behavior;
            message.setReadStatus(message.getStatus());
            message.setLastTime(DateFormatUtils.format((Date)message.getAddTime()));
            if (NumberUtils.isDigits((String)message.getMsgType()) && null != (behavior = PushMessageEnum.getMessageBehaviorByType((int)Integer.parseInt(message.getMsgType())))) {
                message.setHasDetail(Boolean.valueOf(MessageBehaviorEnum.JUMP.equals((Object)behavior)));
            }
            if (this.messageTypeProperties.isInteraction(messageType)) {
                JSONObject linkParam = JSON.parseObject((String)message.getLinkParam());
                JSONObject extend = linkParam.getJSONObject(EXTEND);
                message.setNickname(extend.getString(NICKNAME));
                message.setAction(extend.getString(ACTION));
                message.setIcon(extend.getString(ICON));
                message.setExtendContent(extend.getString(EXTEND_CONTENT));
                message.setExtendUrl(extend.getString(EXTEND_URL));
                message.setReplyId(extend.getLong(REPLY_ID));
                message = (UserMessageBean)this.messageFilterStrategyManage.excute(message, messageType, MessageFilterEventTypeEnum.COMMENT_REPLY_DELETE_EVENT);
            }
        });
        return msgPage;
    }

    @Override
    public MessageTypeDTO getMessageType(String areaCode, Long userId, BasicParam basicParam) {
        MessageTypeDTO msgDto = new MessageTypeDTO();
        ArrayList skipTypes = Lists.newArrayList();
        if (basicParam.getPlatform() == PlatformEnum.APPLET.getCode() || Boolean.TRUE.equals(this.appVersionIntegrationService.getPublishState(basicParam))) {
            skipTypes.add(MessageTypeEnum.BALANCE.name());
        }
        if (basicParam.getPlatform() == PlatformEnum.ANDROID.getCode() || basicParam.getPlatform() == PlatformEnum.IOS.getCode()) {
            skipTypes.add(MessageTypeEnum.INVITE.name());
        }
        this.setMessageList(msgDto, userId, skipTypes, basicParam);
        msgDto.setAdvertDTOS(this.advertIntegrationService.getAdvertByType("10", areaCode, userId));
        return msgDto;
    }

    private void setMessageList(MessageTypeDTO msgDto, Long userId, List<String> skipTypes, BasicParam basicParam) {
        Map<String, Long> unreadNumMap = this.getUnreadMsgNumMap(userId);
        Map<String, MessageType> lastMsgMap = this.getLastMsgMap(userId);
        List msgList = lastMsgMap.values().stream().sorted((pre, next) -> this.dateTimeComparator.compare((Object)next.getSourceLastTime(), (Object)pre.getSourceLastTime())).collect(Collectors.toList());
        ArrayList afterFilter = Lists.newArrayList();
        for (MessageType msgType : msgList) {
            String type = msgType.getMessageType();
            if (null == type || skipTypes.contains(msgType.getMessageType()) || org.apache.commons.lang3.StringUtils.equalsAny((CharSequence)type, (CharSequence[])new CharSequence[]{MessageTypeEnum.LIKE.name(), MessageTypeEnum.COMMENT.name(), MessageTypeEnum.ADD_FUNS.name()}) || NumberUtils.isDigits((String)type)) continue;
            if (null != msgType.getSourceLastTime()) {
                msgType.setLastTime(DateFormatUtils.format((Date)msgType.getSourceLastTime()));
            }
            msgType.setUnreadNum(Integer.valueOf(this.getUnreadIntVal(unreadNumMap, type)));
            MessageType configTypeInfo = this.messageTypeProperties.getMessageInfo(type);
            if (log.isDebugEnabled()) {
                log.debug("match msg type:{}", (Object)configTypeInfo);
            }
            if (null == configTypeInfo) continue;
            msgType.setTitle(configTypeInfo.getTitle());
            msgType.setImg(configTypeInfo.getImg());
            afterFilter.add(msgType);
        }
        msgDto.setMessageTypes((List)afterFilter);
        this.fillNull(msgDto, unreadNumMap);
    }

    private int getUnreadIntVal(Map<String, Long> unreadNumMap, String type) {
        Long unreadNum = unreadNumMap.get(type);
        if (unreadNum == null) {
            return 0;
        }
        return unreadNum.intValue();
    }

    private void fillNull(MessageTypeDTO msgDto, Map<String, Long> unreadNumMap) {
        MessageType likeType = new MessageType();
        likeType.setMessageType(MessageTypeEnum.LIKE.name());
        likeType.setTitle("\u70b9\u8d5e");
        likeType.setUnreadNum(Integer.valueOf(this.getUnreadIntVal(unreadNumMap, MessageTypeEnum.LIKE.name())));
        msgDto.setLikeType(likeType);
        MessageType commentType = new MessageType();
        commentType.setMessageType(MessageTypeEnum.COMMENT.name());
        commentType.setTitle("\u8bc4\u8bba");
        commentType.setUnreadNum(Integer.valueOf(this.getUnreadIntVal(unreadNumMap, MessageTypeEnum.COMMENT.name())));
        msgDto.setCommentType(commentType);
        MessageType followType = new MessageType();
        followType.setMessageType(MessageTypeEnum.ADD_FUNS.name());
        followType.setTitle("\u65b0\u589e\u7c89\u4e1d");
        followType.setUnreadNum(Integer.valueOf(this.getUnreadIntVal(unreadNumMap, MessageTypeEnum.ADD_FUNS.name())));
        msgDto.setFollowType(followType);
        if (msgDto.getMessageTypes() == null) {
            msgDto.setMessageTypes((List)Lists.newArrayList());
        }
        for (String type : this.messageTypeProperties.getMessageTypes()) {
            if (org.apache.commons.lang3.StringUtils.equalsAny((CharSequence)type, (CharSequence[])new CharSequence[]{MessageTypeEnum.LIKE.name(), MessageTypeEnum.COMMENT.name(), MessageTypeEnum.ADD_FUNS.name()}) || msgDto.getMessageTypes().stream().anyMatch(item -> type.equals(item.getMessageType()))) continue;
            MessageType innerType = new MessageType();
            MessageType configTypeInfo = this.messageTypeProperties.getMessageInfo(type);
            if (null == configTypeInfo || null == configTypeInfo.getTitle()) continue;
            innerType.setMessageType(type);
            innerType.setTitle(configTypeInfo.getTitle());
            innerType.setImg(configTypeInfo.getImg());
            msgDto.getMessageTypes().add(innerType);
        }
    }

    private KeyGenerator getUnreadCacheKey(Long userId) {
        return RedisConfig.UN_READ_MSG.copy().appendKey((Object)userId.toString());
    }

    private KeyGenerator getLastMsgCacheKey(Long userId) {
        return RedisConfig.LAST_MSG.copy().appendKey((Object)userId.toString());
    }

    private Map<String, Long> getUnreadMsgNumMap(Long userId) {
        KeyGenerator key = this.getUnreadCacheKey(userId);
        Map<String, Long> result = this.redisHashMapAdapter.entries(key, Long.class);
        if (null == result || result.isEmpty()) {
            result = this.loadHistoryUnread(userId);
            this.redisHashMapAdapter.putAll(key, result);
        }
        for (Map.Entry<String, Long> unreadEntry : result.entrySet()) {
            String subKey = unreadEntry.getKey();
            if (!NumberUtils.isDigits((String)subKey) && !PushMessageEnum.IM_MESSAGE.name().equalsIgnoreCase(subKey)) continue;
            this.redisHashMapAdapter.remove(key, new String[]{subKey});
        }
        return result;
    }

    private Map<String, Long> loadHistoryUnread(Long userId) {
        List unreadTypes = this.messageMapper.getUnreadMap(userId);
        HashMap result = Maps.newHashMap();
        for (Tuple tuple : unreadTypes) {
            String msgType = this.messageTypeProperties.convertType(tuple.getKey());
            Long val = (Long)result.get(msgType);
            val = (val == null ? 0L : val) + (long)tuple.getValue().intValue();
            result.put(msgType, val);
        }
        return result;
    }

    private Map<String, MessageType> getLastMsgMap(Long userId) {
        Map result;
        KeyGenerator key = this.getLastMsgCacheKey(userId);
        if (Boolean.TRUE.equals(this.redisHashMapAdapter.hasKey(key))) {
            result = this.redisHashMapAdapter.entries(key, MessageType.class);
            result.forEach((type, msg) -> {
                if (NumberUtils.isDigits((String)type)) {
                    this.redisHashMapAdapter.remove(key, new String[]{type});
                } else if (this.messageTypeProperties.getMessageInfo((String)type).getTitle() == null) {
                    this.redisHashMapAdapter.remove(key, new String[]{type});
                }
            });
        } else {
            result = this.loadLastMsgHistory(userId);
            this.redisHashMapAdapter.putAll(key, result);
        }
        return result;
    }

    private Map<String, MessageType> loadLastMsgHistory(Long userId) {
        HashMap result = Maps.newHashMap();
        List lastMsgType = this.messageMapper.getLastMsgType(userId);
        List lastIdList = lastMsgType.stream().map(UserMessageBean::getId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(lastIdList)) {
            return result;
        }
        List lastMessages = this.messageMapper.getLastMsg(userId, lastIdList);
        for (UserMessageBean msg : lastMessages) {
            String msgType = this.messageTypeProperties.convertType(msg.getMsgType());
            MessageType messageType = this.build(msg, msgType);
            result.put(msgType, messageType);
        }
        return result;
    }

    @Override
    public void addUnreadMsg(PushMessage message, Long userId) {
        int pushMessageType = message.getPayloadInfo().getType();
        String msgType = this.messageTypeProperties.convertType(pushMessageType);
        if (PushMessageEnum.IM_MESSAGE.name().equalsIgnoreCase(msgType) || msgType.equalsIgnoreCase(PushMessageEnum.IM_MESSAGE.getType() + "s")) {
            return;
        }
        KeyGenerator key = this.getUnreadCacheKey(userId);
        if (Boolean.FALSE.equals(this.redisHashMapAdapter.hasKey(key))) {
            this.redisHashMapAdapter.putAll(key, this.loadHistoryUnread(userId));
            this.redisHashMapAdapter.expire(key, 604800L);
        }
        this.redisHashMapAdapter.increment(key, msgType, 1);
        this.addMessageTypeLastMsg(message, userId, msgType);
        log.info("\u6dfb\u52a0\u672a\u8bfb\u6d88\u606f\uff0c\u7528\u6237id\uff1a{}, \u672a\u8bfb\u6d88\u606f\u7c7b\u578b\uff1a{}", (Object)userId, (Object)pushMessageType);
        if (PushMessageEnum.BELONG_POST_REPLY.getType() == pushMessageType || PushMessageEnum.BELONG_POST_LIKE.getType() == pushMessageType) {
            InteractMessageDTO interactMessageDTO = this.getUnReadInteractMessage(userId);
            this.addInteractUserEvent(userId, interactMessageDTO);
        }
        this.addUnReadUserEvent(userId, msgType);
        if (this.messageTypeProperties.isInteraction(msgType)) {
            this.addInteractionCache(message, userId, msgType);
        }
    }

    private void addInteractUserEvent(Long userId, InteractMessageDTO interactMessageDTO) {
        PushPayloadInfo interactMessageInfo = PushPayloadInfo.build().setType(UserEventEnum.UN_READ_INTERACT_MSG.type).addExtend("messageCount", (Object)interactMessageDTO.getMessageCount()).addExtend("headImageUrl", (Object)interactMessageDTO.getHeadImageUrl()).addExtend("latestMessageType", (Object)interactMessageDTO.getLatestMessageType()).addExtend("jumpUrl", (Object)interactMessageDTO.getJumpUrl()).addExtend("userId", (Object)userId);
        log.info("\u6dfb\u52a0\u4e92\u52a8\u6d88\u606f\u672a\u8bfb\u4e8b\u4ef6\uff1auserId:{},\u6d88\u606f\u5185\u5bb9\uff1a{}", (Object)userId, (Object)JSON.toJSONString((Object)interactMessageDTO));
        this.userEventService.add(interactMessageInfo);
    }

    @Override
    public void addLastMsg(PushMessage message) {
        Preconditions.checkArgument((null != message ? 1 : 0) != 0);
        Long userId = message.getPushReceiveScope().getUserId();
        String msgType = this.messageTypeProperties.convertType(message.getPayloadInfo().getType());
        this.addMessageTypeLastMsg(message, userId, msgType);
    }

    private void addInteractionCache(PushMessage message, Long userId, String msgType) {
        int index = IntervalPeriodUtils.getIntervalIndex();
        KeyGenerator key = RedisConfig.LAST_INTERACTION_MSG.copy().appendKey((Object)index).appendKey((Object)msgType);
        this.redisHashMapAdapter.put(key, userId.toString(), (Object)message);
        this.redisHashMapAdapter.expire(key, 3600L);
        key = RedisConfig.INTERACTION_NUM.copy().appendKey((Object)index).appendKey((Object)msgType);
        this.redisHashMapAdapter.increment(key, userId.toString(), 1);
        this.redisHashMapAdapter.expire(key, 3600L);
    }

    private void removeInteractionCache(Long userId, String msgType) {
        int index = IntervalPeriodUtils.getIntervalIndex();
        KeyGenerator key = RedisConfig.LAST_INTERACTION_MSG.copy().appendKey((Object)index).appendKey((Object)msgType);
        this.redisHashMapAdapter.remove(key, new String[]{userId.toString()});
        key = RedisConfig.INTERACTION_NUM.copy().appendKey((Object)index).appendKey((Object)msgType);
        this.redisHashMapAdapter.put(key, userId.toString(), (Object)0);
    }

    private MessageType build(UserMessageBean message, String msgType) {
        MessageType messageType = new MessageType();
        messageType.setMessageType(msgType);
        messageType.setSourceLastTime(message.getAddTime());
        if (this.messageTypeProperties.isInteraction(msgType)) {
            JSONObject extend = JSON.parseObject((String)message.getLinkParam());
            String nickName = Objects.toString(extend.get((Object)NICKNAME), "");
            String action = Objects.toString(extend.get((Object)ACTION), "");
            messageType.setDescription(nickName + action);
        } else {
            messageType.setDescription(message.getContent());
        }
        return messageType;
    }

    private void addMessageTypeLastMsg(PushMessage message, Long userId, String msgType) {
        String nickname;
        Map extend;
        MessageType entity = new MessageType();
        KeyGenerator key = this.getLastMsgCacheKey(userId);
        if (Boolean.FALSE.equals(this.redisHashMapAdapter.hasKey(key))) {
            Map<String, MessageType> historyMap = this.loadLastMsgHistory(userId);
            this.redisHashMapAdapter.putAll(key, historyMap);
            this.redisHashMapAdapter.expire(key, 604800L);
        }
        if (this.messageTypeProperties.isInteraction(msgType)) {
            extend = message.getPayloadInfo().getExtend();
            String nickName = Objects.toString(extend.get(NICKNAME), "");
            String action = Objects.toString(extend.get(ACTION), "");
            entity.setDescription(nickName + action);
        } else {
            entity.setDescription(message.getContent());
        }
        if (PushMessageEnum.IM_MESSAGE.name().equals(msgType)) {
            extend = message.getPayloadInfo().getExtend();
            nickname = Objects.toString(extend.get(NICKNAME), "");
            String headImg = Objects.toString(extend.get(HEAD_IMG), "");
            String customType = Objects.toString(extend.get(CUSTOM_TYPE), "");
            entity.setImg(headImg);
            entity.setTitle(nickname);
            entity.setMessageType(customType);
            msgType = customType;
        }
        if (MessageTypeEnum.COMMENT.name().equals(msgType) || MessageTypeEnum.LIKE.name().equals(msgType)) {
            extend = message.getPayloadInfo().getExtend();
            nickname = Objects.toString(extend.get(ICON), "");
            entity.setHeadIcon(nickname);
        }
        entity.setSourceLastTime(new Date());
        entity.setMessageType(msgType);
        this.redisHashMapAdapter.put(key, msgType, (Object)entity);
    }

    @Override
    public void updateMessageByType(Long userId, String messageType) {
        if (!NumberUtils.isDigits((String)messageType) && !MessageTypeEnum.ADD_FUNS.name().equals(messageType)) {
            MessageListParam messageListParam = new MessageListParam();
            messageListParam.setUserId(userId);
            messageListParam.setMessageType(messageType);
            this.constructionParam(messageListParam);
            this.messageMapper.updateMessageByType(messageListParam);
        }
        this.redisHashMapAdapter.put(this.getUnreadCacheKey(userId), messageType, (Object)0L);
        if (this.messageTypeProperties.isInteraction(messageType)) {
            this.removeInteractionCache(userId, messageType);
        }
        if (MessageTypeEnum.COMMENT.name().equalsIgnoreCase(messageType) || MessageTypeEnum.LIKE.name().equalsIgnoreCase(messageType)) {
            InteractMessageDTO interactMessageDTO = this.getUnReadInteractMessage(userId);
            this.addInteractUserEvent(userId, interactMessageDTO);
        }
        this.addUnReadUserEvent(userId, messageType);
    }

    @Override
    public void addMessage(PushMessage message, Long userId) {
        UserMessageBean entity = new UserMessageBean();
        entity.setId(this.sequenceCreater.nextLongId());
        entity.setTitle(this.removeNonBmpUnicodes(message.getTitle()));
        entity.setContent(this.removeNonBmpUnicodes(message.getContent()));
        entity.setUserId(userId);
        entity.setMsgType(String.valueOf(message.getPayloadInfo().getType()));
        entity.setStatus(Byte.valueOf((byte)0));
        entity.setLinkParam(this.removeNonBmpUnicodes(JSON.toJSONString((Object)message.getPayloadInfo())));
        entity.setAddTime(new Date());
        this.addUnreadMsg(message, userId);
        if (message.isPersistence()) {
            this.messageMapper.insertSelective(entity);
        }
    }

    private String removeNonBmpUnicodes(String source) {
        if (this.messageTypeProperties.isFilterEmoji()) {
            return null == source ? null : source.replaceAll("[^\\u0000-\\uFFFF]", "");
        }
        return source;
    }

    @Override
    public Map<String, Long> getUnReadNum(Long userId, String messageType) {
        HashMap resultMap = Maps.newHashMap();
        Map<String, Long> unReadMap = this.getUnreadMsgNumMap(userId);
        if (StringUtils.isBlank((String)messageType)) {
            return resultMap;
        }
        if (!unReadMap.containsKey(messageType)) {
            return resultMap;
        }
        resultMap.put(messageType, unReadMap.get(messageType));
        return this.getUnreadMsgNumMap(userId);
    }

    @Override
    public MessageTypeNewDTO getMessageCenterList(String areaCode, Long userId, MsgCenterNewParam basicParam) {
        MessageTypeNewDTO msgDto = new MessageTypeNewDTO();
        ArrayList skipTypes = Lists.newArrayList();
        if (basicParam.getPlatform() == PlatformEnum.APPLET.getCode() || Boolean.TRUE.equals(this.appVersionIntegrationService.getPublishState((BasicParam)basicParam))) {
            skipTypes.add(MessageTypeEnum.BALANCE.name());
        }
        if (basicParam.getPlatform() == PlatformEnum.ANDROID.getCode() || basicParam.getPlatform() == PlatformEnum.IOS.getCode()) {
            skipTypes.add(MessageTypeEnum.INVITE.name());
        }
        boolean isShowWelfare = false;
        List<String> welfareAreaList = this.messageTypeProperties.getWelfareAreaList();
        if (!welfareAreaList.isEmpty()) {
            boolean contains = welfareAreaList.contains(areaCode);
            if (contains) {
                isShowWelfare = true;
            }
        } else {
            isShowWelfare = true;
        }
        this.setNewMessageList(msgDto, userId, skipTypes, isShowWelfare);
        msgDto.setAdvertDTOS(this.advertIntegrationService.getAdvertByType("10", areaCode, userId));
        return msgDto;
    }

    @Override
    public Boolean hasLatestMessage(Long userId, String areaCode, Byte type, BasicParam basicParam) {
        Map<String, Long> unreadNumMap = this.getUnreadMsgNumMap(userId);
        if (type == null || userId == null) {
            return false;
        }
        Long result = null;
        switch (type) {
            case 0: {
                result = unreadNumMap.get(MessageTypeEnum.COMMENT.name());
                break;
            }
            case 1: {
                result = unreadNumMap.get(MessageTypeEnum.LIKE.name());
                break;
            }
            default: {
                return false;
            }
        }
        if (result == null) {
            return false;
        }
        return result > 0L;
    }

    @Override
    public InteractMessageDTO getUnReadInteractMessage(Long userId) {
        InteractMessageDTO interactMessageDTO = new InteractMessageDTO();
        String jumpUrlFormatStr = "wst://message/commentLike?selectedTab=%s";
        interactMessageDTO.setJumpUrl(String.format(jumpUrlFormatStr, 0));
        if (Boolean.FALSE.equals(this.interactMessageProperties.getOpen())) {
            return interactMessageDTO;
        }
        Map<String, Long> unreadNumMap = this.getUnreadMsgNumMap(userId);
        int messageCount = 0;
        long commentUnReadMsgCount = this.getLongValue(unreadNumMap.get(MessageTypeEnum.COMMENT.name()));
        long likeUnReadMsgCount = this.getLongValue(unreadNumMap.get(MessageTypeEnum.LIKE.name()));
        messageCount = (int)((long)messageCount + commentUnReadMsgCount);
        messageCount = (int)((long)messageCount + likeUnReadMsgCount);
        log.info("\u7528\u6237id: {}, \u8bc4\u8bba\u6d88\u606f\u6570\u91cf\uff1a{},\u70b9\u8d5e\u6d88\u606f\u6570\u91cf\uff1a{}", new Object[]{userId, unreadNumMap.get(MessageTypeEnum.COMMENT.name()), unreadNumMap.get(MessageTypeEnum.LIKE.name())});
        interactMessageDTO.setMessageCount(Integer.valueOf(messageCount));
        if (messageCount <= 0) {
            return interactMessageDTO;
        }
        Map<String, MessageType> lastMsgMap = this.getLastMsgMap(userId);
        MessageType commentLastMsg = lastMsgMap.get(MessageTypeEnum.COMMENT.name());
        MessageType likeLastMsg = lastMsgMap.get(MessageTypeEnum.LIKE.name());
        if (likeUnReadMsgCount <= 0L && commentUnReadMsgCount > 0L) {
            interactMessageDTO.setLatestMessageType(Byte.valueOf((byte)0));
            if (commentLastMsg != null) {
                String headIcon = commentLastMsg.getHeadIcon();
                interactMessageDTO.setHeadImageUrl(org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)headIcon) ? headIcon : this.interactMessageProperties.getDefaultHeadImg());
            }
            return interactMessageDTO;
        }
        if (commentUnReadMsgCount <= 0L && likeUnReadMsgCount > 0L) {
            interactMessageDTO.setLatestMessageType(Byte.valueOf((byte)1));
            if (likeLastMsg != null) {
                String headIcon = likeLastMsg.getHeadIcon();
                interactMessageDTO.setJumpUrl(String.format(jumpUrlFormatStr, 1));
                interactMessageDTO.setHeadImageUrl(org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)headIcon) ? headIcon : this.interactMessageProperties.getDefaultHeadImg());
            }
            return interactMessageDTO;
        }
        if (likeUnReadMsgCount > 0L && commentUnReadMsgCount > 0L) {
            if (commentLastMsg != null && likeLastMsg != null) {
                Date likeCreateTime;
                Date commentCreateTime = commentLastMsg.getSourceLastTime();
                if (DateUtils.after((Date)commentCreateTime, (Date)(likeCreateTime = likeLastMsg.getSourceLastTime()))) {
                    interactMessageDTO.setLatestMessageType(Byte.valueOf((byte)0));
                    String headIcon = commentLastMsg.getHeadIcon();
                    interactMessageDTO.setHeadImageUrl(org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)headIcon) ? headIcon : this.interactMessageProperties.getDefaultHeadImg());
                } else {
                    interactMessageDTO.setLatestMessageType(Byte.valueOf((byte)1));
                    interactMessageDTO.setJumpUrl(String.format(jumpUrlFormatStr, 1));
                    String headIcon = likeLastMsg.getHeadIcon();
                    interactMessageDTO.setHeadImageUrl(org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)headIcon) ? headIcon : this.interactMessageProperties.getDefaultHeadImg());
                }
            }
            return interactMessageDTO;
        }
        log.info("\u7528\u6237\u4e92\u52a8\u6d88\u606f\u4fe1\u606f\uff1a\u7528\u6237id-{}, \u4e92\u52a8\u6d88\u606f\u4fe1\u606f\uff1a{}", (Object)userId, (Object)JSON.toJSONString((Object)interactMessageDTO));
        return interactMessageDTO;
    }

    public long getLongValue(Long value) {
        return value == null ? 0L : value;
    }

    private void setNewMessageList(MessageTypeNewDTO msgDto, Long userId, List<String> skipTypes, boolean isShowWelfare) {
        Map<String, Long> unreadNumMap = this.getUnreadMsgNumMap(userId);
        Map<String, MessageType> lastMsgMap = this.getLastMsgMap(userId);
        List msgList = lastMsgMap.values().stream().sorted((pre, next) -> this.dateTimeComparator.compare((Object)next.getSourceLastTime(), (Object)pre.getSourceLastTime())).collect(Collectors.toList());
        ArrayList afterFilter = Lists.newArrayList();
        for (MessageType msgType : msgList) {
            String type = msgType.getMessageType();
            if (null == type || skipTypes.contains(msgType.getMessageType()) || !isShowWelfare && Objects.equals(type, MessageTypeEnum.MERCHANT_WELFARE.name()) || org.apache.commons.lang3.StringUtils.equalsAny((CharSequence)type, (CharSequence[])new CharSequence[]{MessageTypeEnum.LIKE.name(), MessageTypeEnum.COMMENT.name(), MessageTypeEnum.ADD_FUNS.name(), MessageTypeEnum.NEWS.name()}) || NumberUtils.isDigits((String)type)) continue;
            if (Objects.equals(type, MessageTypeEnum.MERCHANT_WELFARE.name())) {
                msgType.setDescription(msgType.getDescription());
            }
            if (null != msgType.getSourceLastTime()) {
                msgType.setLastTime(DateFormatUtils.format((Date)msgType.getSourceLastTime()));
            }
            msgType.setUnreadNum(Integer.valueOf(this.getUnreadIntVal(unreadNumMap, type)));
            MessageType configTypeInfo = this.messageTypeProperties.getMessageInfo(type);
            if (log.isDebugEnabled()) {
                log.debug("match msg type:{}", (Object)configTypeInfo);
            }
            if (null == configTypeInfo) continue;
            msgType.setTitle(configTypeInfo.getTitle());
            msgType.setImg(configTypeInfo.getImg());
            afterFilter.add(msgType);
        }
        msgDto.setMessageTypes((List)afterFilter);
        this.newFillNull(msgDto, unreadNumMap, isShowWelfare);
    }

    private void newFillNull(MessageTypeNewDTO msgDto, Map<String, Long> unreadNumMap, boolean isShowWelfare) {
        MessageType commentAndLikeType = new MessageType();
        commentAndLikeType.setMessageType(MessageTypeEnum.LIKE_AND_COMMENT.name());
        commentAndLikeType.setTitle("\u8bc4\u8bba\u70b9\u8d5e");
        commentAndLikeType.setUnreadNum(Integer.valueOf(this.getUnreadIntVal(unreadNumMap, MessageTypeEnum.LIKE.name()) + this.getUnreadIntVal(unreadNumMap, MessageTypeEnum.COMMENT.name())));
        msgDto.setCommentAndLikeType(commentAndLikeType);
        MessageType followType = new MessageType();
        followType.setMessageType(MessageTypeEnum.ADD_FUNS.name());
        followType.setTitle("\u65b0\u589e\u7c89\u4e1d");
        followType.setUnreadNum(Integer.valueOf(this.getUnreadIntVal(unreadNumMap, MessageTypeEnum.ADD_FUNS.name())));
        msgDto.setFollowType(followType);
        MessageType newsType = new MessageType();
        newsType.setMessageType(MessageTypeEnum.NEWS.name());
        newsType.setTitle("\u4eca\u65e5\u70ed\u95fb");
        newsType.setUnreadNum(Integer.valueOf(this.getUnreadIntVal(unreadNumMap, MessageTypeEnum.NEWS.name())));
        msgDto.setTodayNews(newsType);
        if (msgDto.getMessageTypes() == null) {
            msgDto.setMessageTypes((List)Lists.newArrayList());
        }
        for (String type : this.messageTypeProperties.getMessageTypes()) {
            if (org.apache.commons.lang3.StringUtils.equalsAny((CharSequence)type, (CharSequence[])new CharSequence[]{MessageTypeEnum.LIKE.name(), MessageTypeEnum.COMMENT.name(), MessageTypeEnum.ADD_FUNS.name(), MessageTypeEnum.NEWS.name()}) || msgDto.getMessageTypes().stream().anyMatch(item -> type.equals(item.getMessageType())) || !isShowWelfare && Objects.equals(type, MessageTypeEnum.MERCHANT_WELFARE.name())) continue;
            MessageType innerType = new MessageType();
            MessageType configTypeInfo = this.messageTypeProperties.getMessageInfo(type);
            if (null == configTypeInfo || null == configTypeInfo.getTitle()) continue;
            innerType.setMessageType(type);
            innerType.setTitle(configTypeInfo.getTitle());
            innerType.setImg(configTypeInfo.getImg());
            msgDto.getMessageTypes().add(innerType);
        }
    }

    private void addUnReadUserEvent(Long userId, String msgType) {
        if (!(MessageTypeEnum.BALANCE.name().equals(msgType) || MessageTypeEnum.INVITE.name().equals(msgType) || PushMessageEnum.IM_MESSAGE.name().equals(msgType))) {
            this.userEventService.add(this.buildSystemPush(userId));
        }
    }

    private PushPayloadInfo buildSystemPush(Long userId) {
        return PushPayloadInfo.build().setType(UserEventEnum.UN_READ_SYSTEM_MSG.type).addExtend("userId", (Object)userId).addExtend("current", (Object)this.getUnReadMsg(userId, 0, "3.0.0"));
    }

    @Deprecated
    private PushPayloadInfo buildPushPayloadInfo(Long userId) {
        return PushPayloadInfo.build().setType(UserEventEnum.USER_UN_READ_MSG.type).addExtend("userId", (Object)userId).addExtend("current", (Object)this.getUnReadMsg(userId, 0, null));
    }

    @Deprecated
    private PushPayloadInfo buildAppletPushPayloadInfo(Long userId) {
        return PushPayloadInfo.build().setType(UserEventEnum.APPLET_USER_UN_READ_MSG.type).addExtend("userId", (Object)userId).addExtend("current", (Object)this.getUnReadMsg(userId, 5, null));
    }

    private void pushTemplateMessage(PushMessage pushMessage, Long userId) {
        int type = pushMessage.getPayloadInfo().getType();
        if (this.messageTypeProperties.getTemplate().contains(type)) {
            PushMessage cloneMsg = PushMessage.build();
            BeanUtils.copyProperties((Object)pushMessage, (Object)cloneMsg);
            cloneMsg.setPushReceiveScope(PushReceiveScope.pushRule((PushReceiverRuleEnum)PushReceiverRuleEnum.DEFAULT).addRuleParam("userIds", (Object)userId));
            this.pushTemplateMessageIntegrationService.pushTemplateMessage(cloneMsg);
        }
    }

    private void constructionParam(MessageListParam param) {
        if (StringUtils.isNotEmpty((String)param.getMessageType()) && MessageTypeEnum.INTERACTION.name().equals(param.getMessageType())) {
            List<String> msgTypeList = this.messageTypeProperties.getSubTypes(MessageTypeEnum.COMMENT.name());
            msgTypeList.addAll(this.messageTypeProperties.getSubTypes(MessageTypeEnum.LIKE.name()));
            param.setMsgTypeList(msgTypeList);
        } else {
            param.setMsgTypeList(this.messageTypeProperties.getSubTypes(param.getMessageType()));
        }
    }
}

