/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.msg.config;

import com.bxm.localnews.mq.common.constant.MessageTypeEnum;
import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.msg.config.MesssageTypeConfigInfo;
import com.bxm.localnews.msg.dto.MessageType;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(value="message.config.message")
public class MessageTypeProperties {
    private static final Logger log = LoggerFactory.getLogger(MessageTypeProperties.class);
    private Map<String, MesssageTypeConfigInfo> msgTypeConfig = Maps.newHashMap();
    private boolean filterEmoji = true;
    private List<Integer> template = Lists.newArrayList();

    public String convertType(Object pushMsgType) {
        String type = Objects.toString(pushMsgType);
        if (String.valueOf(PushMessageEnum.ADD_FUNS.getType()).equals(type)) {
            return PushMessageEnum.ADD_FUNS.name();
        }
        if (String.valueOf(PushMessageEnum.IM_MESSAGE.getType()).equals(type)) {
            return PushMessageEnum.IM_MESSAGE.name();
        }
        if (NumberUtils.isDigits((String)type)) {
            for (MesssageTypeConfigInfo msgType : this.msgTypeConfig.values()) {
                if (!msgType.getSubTypes().contains(type)) continue;
                return msgType.getType();
            }
        }
        return pushMsgType.toString();
    }

    public List<String> getMessageTypes() {
        List configInfos = this.msgTypeConfig.values().stream().sorted(Comparator.comparingInt(MesssageTypeConfigInfo::getIndex)).collect(Collectors.toList());
        return configInfos.stream().map(MesssageTypeConfigInfo::getType).collect(Collectors.toList());
    }

    public List<String> getSubTypes(String msgType) {
        for (MesssageTypeConfigInfo configInfo : this.msgTypeConfig.values()) {
            if (!Objects.equals(msgType, configInfo.getType())) continue;
            return configInfo.getSubTypes();
        }
        return Lists.newArrayList();
    }

    public MessageType getMessageInfo(String msgType) {
        for (MesssageTypeConfigInfo configInfo : this.msgTypeConfig.values()) {
            if (!Objects.equals(configInfo.getType(), msgType)) continue;
            return this.convert(configInfo);
        }
        log.warn("\u672a\u914d\u7f6e\u7684\u6d88\u606f\u7c7b\u578b[{}]", (Object)msgType);
        return new MessageType();
    }

    private MessageType convert(MesssageTypeConfigInfo configInfo) {
        MessageType messageType = new MessageType();
        messageType.setImg(configInfo.getIcon());
        messageType.setTitle(configInfo.getLabel());
        messageType.setMessageType(configInfo.getType());
        return messageType;
    }

    public boolean isInteraction(String msgType) {
        return MessageTypeEnum.COMMENT.name().equals(msgType) || MessageTypeEnum.LIKE.name().equals(msgType) || MessageTypeEnum.INVITE.name().equals(msgType) || MessageTypeEnum.SHARE.name().equals(msgType);
    }

    public Set<MessageTypeEnum> getInteractionType() {
        return ImmutableSet.of((Object)MessageTypeEnum.COMMENT, (Object)MessageTypeEnum.LIKE, (Object)MessageTypeEnum.INVITE, (Object)MessageTypeEnum.SHARE);
    }

    public Map<String, MesssageTypeConfigInfo> getMsgTypeConfig() {
        return this.msgTypeConfig;
    }

    public boolean isFilterEmoji() {
        return this.filterEmoji;
    }

    public List<Integer> getTemplate() {
        return this.template;
    }

    public void setMsgTypeConfig(Map<String, MesssageTypeConfigInfo> msgTypeConfig) {
        this.msgTypeConfig = msgTypeConfig;
    }

    public void setFilterEmoji(boolean filterEmoji) {
        this.filterEmoji = filterEmoji;
    }

    public void setTemplate(List<Integer> template) {
        this.template = template;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MessageTypeProperties)) {
            return false;
        }
        MessageTypeProperties other = (MessageTypeProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, MesssageTypeConfigInfo> this$msgTypeConfig = this.getMsgTypeConfig();
        Map<String, MesssageTypeConfigInfo> other$msgTypeConfig = other.getMsgTypeConfig();
        if (this$msgTypeConfig == null ? other$msgTypeConfig != null : !((Object)this$msgTypeConfig).equals(other$msgTypeConfig)) {
            return false;
        }
        if (this.isFilterEmoji() != other.isFilterEmoji()) {
            return false;
        }
        List<Integer> this$template = this.getTemplate();
        List<Integer> other$template = other.getTemplate();
        return !(this$template == null ? other$template != null : !((Object)this$template).equals(other$template));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MessageTypeProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, MesssageTypeConfigInfo> $msgTypeConfig = this.getMsgTypeConfig();
        result = result * 59 + ($msgTypeConfig == null ? 43 : ((Object)$msgTypeConfig).hashCode());
        result = result * 59 + (this.isFilterEmoji() ? 79 : 97);
        List<Integer> $template = this.getTemplate();
        result = result * 59 + ($template == null ? 43 : ((Object)$template).hashCode());
        return result;
    }

    public String toString() {
        return "MessageTypeProperties(msgTypeConfig=" + this.getMsgTypeConfig() + ", filterEmoji=" + this.isFilterEmoji() + ", template=" + this.getTemplate() + ")";
    }
}

